# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.repository_ruleset_conditions_repository_property_spec import RepositoryRulesetConditionsRepositoryPropertySpec
from typing import Optional, Set
from typing_extensions import Self

class RepositoryRulesetConditionsRepositoryPropertyTargetRepositoryProperty(BaseModel):
    """
    RepositoryRulesetConditionsRepositoryPropertyTargetRepositoryProperty
    """ # noqa: E501
    include: Optional[List[RepositoryRulesetConditionsRepositoryPropertySpec]] = Field(default=None, description="The repository properties and values to include. All of these properties must match for the condition to pass.")
    exclude: Optional[List[RepositoryRulesetConditionsRepositoryPropertySpec]] = Field(default=None, description="The repository properties and values to exclude. The condition will not pass if any of these properties match.")
    __properties: ClassVar[List[str]] = ["include", "exclude"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RepositoryRulesetConditionsRepositoryPropertyTargetRepositoryProperty from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in include (list)
        _items = []
        if self.include:
            for _item_include in self.include:
                if _item_include:
                    _items.append(_item_include.to_dict())
            _dict['include'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in exclude (list)
        _items = []
        if self.exclude:
            for _item_exclude in self.exclude:
                if _item_exclude:
                    _items.append(_item_exclude.to_dict())
            _dict['exclude'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RepositoryRulesetConditionsRepositoryPropertyTargetRepositoryProperty from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "include": [RepositoryRulesetConditionsRepositoryPropertySpec.from_dict(_item) for _item in obj["include"]] if obj.get("include") is not None else None,
            "exclude": [RepositoryRulesetConditionsRepositoryPropertySpec.from_dict(_item) for _item in obj["exclude"]] if obj.get("exclude") is not None else None
        })
        return _obj


