# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class RepositoryVulnerabilityAlertAlert1(BaseModel):
    """
    The security alert of the vulnerable dependency.
    """ # noqa: E501
    affected_package_name: StrictStr
    affected_range: StrictStr
    created_at: StrictStr
    dismiss_reason: Optional[StrictStr] = None
    dismissed_at: Optional[StrictStr] = None
    dismisser: Optional[User] = None
    external_identifier: StrictStr
    external_reference: Optional[StrictStr]
    fix_reason: Optional[StrictStr] = None
    fixed_at: Optional[datetime] = None
    fixed_in: Optional[StrictStr] = None
    ghsa_id: StrictStr
    id: StrictInt
    node_id: StrictStr
    number: StrictInt
    severity: StrictStr
    state: StrictStr
    __properties: ClassVar[List[str]] = ["affected_package_name", "affected_range", "created_at", "dismiss_reason", "dismissed_at", "dismisser", "external_identifier", "external_reference", "fix_reason", "fixed_at", "fixed_in", "ghsa_id", "id", "node_id", "number", "severity", "state"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['fixed', 'open']):
            raise ValueError("must be one of enum values ('fixed', 'open')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RepositoryVulnerabilityAlertAlert1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of dismisser
        if self.dismisser:
            _dict['dismisser'] = self.dismisser.to_dict()
        # set to None if dismisser (nullable) is None
        # and model_fields_set contains the field
        if self.dismisser is None and "dismisser" in self.model_fields_set:
            _dict['dismisser'] = None

        # set to None if external_reference (nullable) is None
        # and model_fields_set contains the field
        if self.external_reference is None and "external_reference" in self.model_fields_set:
            _dict['external_reference'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RepositoryVulnerabilityAlertAlert1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "affected_package_name": obj.get("affected_package_name"),
            "affected_range": obj.get("affected_range"),
            "created_at": obj.get("created_at"),
            "dismiss_reason": obj.get("dismiss_reason"),
            "dismissed_at": obj.get("dismissed_at"),
            "dismisser": User.from_dict(obj["dismisser"]) if obj.get("dismisser") is not None else None,
            "external_identifier": obj.get("external_identifier"),
            "external_reference": obj.get("external_reference"),
            "fix_reason": obj.get("fix_reason"),
            "fixed_at": obj.get("fixed_at"),
            "fixed_in": obj.get("fixed_in"),
            "ghsa_id": obj.get("ghsa_id"),
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "number": obj.get("number"),
            "severity": obj.get("severity"),
            "state": obj.get("state")
        })
        return _obj


