# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.minimal_repository_permissions import MinimalRepositoryPermissions
from devopso.clients.github.models.repository_webhooks_template_repository_owner import RepositoryWebhooksTemplateRepositoryOwner
from typing import Optional, Set
from typing_extensions import Self

class RepositoryWebhooksTemplateRepository(BaseModel):
    """
    RepositoryWebhooksTemplateRepository
    """ # noqa: E501
    id: Optional[StrictInt] = None
    node_id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    full_name: Optional[StrictStr] = None
    owner: Optional[RepositoryWebhooksTemplateRepositoryOwner] = None
    private: Optional[StrictBool] = None
    html_url: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    fork: Optional[StrictBool] = None
    url: Optional[StrictStr] = None
    archive_url: Optional[StrictStr] = None
    assignees_url: Optional[StrictStr] = None
    blobs_url: Optional[StrictStr] = None
    branches_url: Optional[StrictStr] = None
    collaborators_url: Optional[StrictStr] = None
    comments_url: Optional[StrictStr] = None
    commits_url: Optional[StrictStr] = None
    compare_url: Optional[StrictStr] = None
    contents_url: Optional[StrictStr] = None
    contributors_url: Optional[StrictStr] = None
    deployments_url: Optional[StrictStr] = None
    downloads_url: Optional[StrictStr] = None
    events_url: Optional[StrictStr] = None
    forks_url: Optional[StrictStr] = None
    git_commits_url: Optional[StrictStr] = None
    git_refs_url: Optional[StrictStr] = None
    git_tags_url: Optional[StrictStr] = None
    git_url: Optional[StrictStr] = None
    issue_comment_url: Optional[StrictStr] = None
    issue_events_url: Optional[StrictStr] = None
    issues_url: Optional[StrictStr] = None
    keys_url: Optional[StrictStr] = None
    labels_url: Optional[StrictStr] = None
    languages_url: Optional[StrictStr] = None
    merges_url: Optional[StrictStr] = None
    milestones_url: Optional[StrictStr] = None
    notifications_url: Optional[StrictStr] = None
    pulls_url: Optional[StrictStr] = None
    releases_url: Optional[StrictStr] = None
    ssh_url: Optional[StrictStr] = None
    stargazers_url: Optional[StrictStr] = None
    statuses_url: Optional[StrictStr] = None
    subscribers_url: Optional[StrictStr] = None
    subscription_url: Optional[StrictStr] = None
    tags_url: Optional[StrictStr] = None
    teams_url: Optional[StrictStr] = None
    trees_url: Optional[StrictStr] = None
    clone_url: Optional[StrictStr] = None
    mirror_url: Optional[StrictStr] = None
    hooks_url: Optional[StrictStr] = None
    svn_url: Optional[StrictStr] = None
    homepage: Optional[StrictStr] = None
    language: Optional[StrictStr] = None
    forks_count: Optional[StrictInt] = None
    stargazers_count: Optional[StrictInt] = None
    watchers_count: Optional[StrictInt] = None
    size: Optional[StrictInt] = None
    default_branch: Optional[StrictStr] = None
    open_issues_count: Optional[StrictInt] = None
    is_template: Optional[StrictBool] = None
    topics: Optional[List[StrictStr]] = None
    has_issues: Optional[StrictBool] = None
    has_projects: Optional[StrictBool] = None
    has_wiki: Optional[StrictBool] = None
    has_pages: Optional[StrictBool] = None
    has_downloads: Optional[StrictBool] = None
    archived: Optional[StrictBool] = None
    disabled: Optional[StrictBool] = None
    visibility: Optional[StrictStr] = None
    pushed_at: Optional[StrictStr] = None
    created_at: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    permissions: Optional[MinimalRepositoryPermissions] = None
    allow_rebase_merge: Optional[StrictBool] = None
    temp_clone_token: Optional[StrictStr] = None
    allow_squash_merge: Optional[StrictBool] = None
    allow_auto_merge: Optional[StrictBool] = None
    delete_branch_on_merge: Optional[StrictBool] = None
    allow_update_branch: Optional[StrictBool] = None
    use_squash_pr_title_as_default: Optional[StrictBool] = None
    squash_merge_commit_title: Optional[StrictStr] = Field(default=None, description="The default value for a squash merge commit title:  - `PR_TITLE` - default to the pull request's title. - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).")
    squash_merge_commit_message: Optional[StrictStr] = Field(default=None, description="The default value for a squash merge commit message:  - `PR_BODY` - default to the pull request's body. - `COMMIT_MESSAGES` - default to the branch's commit messages. - `BLANK` - default to a blank commit message.")
    merge_commit_title: Optional[StrictStr] = Field(default=None, description="The default value for a merge commit title.  - `PR_TITLE` - default to the pull request's title. - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).")
    merge_commit_message: Optional[StrictStr] = Field(default=None, description="The default value for a merge commit message.  - `PR_TITLE` - default to the pull request's title. - `PR_BODY` - default to the pull request's body. - `BLANK` - default to a blank commit message.")
    allow_merge_commit: Optional[StrictBool] = None
    subscribers_count: Optional[StrictInt] = None
    network_count: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["id", "node_id", "name", "full_name", "owner", "private", "html_url", "description", "fork", "url", "archive_url", "assignees_url", "blobs_url", "branches_url", "collaborators_url", "comments_url", "commits_url", "compare_url", "contents_url", "contributors_url", "deployments_url", "downloads_url", "events_url", "forks_url", "git_commits_url", "git_refs_url", "git_tags_url", "git_url", "issue_comment_url", "issue_events_url", "issues_url", "keys_url", "labels_url", "languages_url", "merges_url", "milestones_url", "notifications_url", "pulls_url", "releases_url", "ssh_url", "stargazers_url", "statuses_url", "subscribers_url", "subscription_url", "tags_url", "teams_url", "trees_url", "clone_url", "mirror_url", "hooks_url", "svn_url", "homepage", "language", "forks_count", "stargazers_count", "watchers_count", "size", "default_branch", "open_issues_count", "is_template", "topics", "has_issues", "has_projects", "has_wiki", "has_pages", "has_downloads", "archived", "disabled", "visibility", "pushed_at", "created_at", "updated_at", "permissions", "allow_rebase_merge", "temp_clone_token", "allow_squash_merge", "allow_auto_merge", "delete_branch_on_merge", "allow_update_branch", "use_squash_pr_title_as_default", "squash_merge_commit_title", "squash_merge_commit_message", "merge_commit_title", "merge_commit_message", "allow_merge_commit", "subscribers_count", "network_count"]

    @field_validator('squash_merge_commit_title')
    def squash_merge_commit_title_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PR_TITLE', 'COMMIT_OR_PR_TITLE']):
            raise ValueError("must be one of enum values ('PR_TITLE', 'COMMIT_OR_PR_TITLE')")
        return value

    @field_validator('squash_merge_commit_message')
    def squash_merge_commit_message_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PR_BODY', 'COMMIT_MESSAGES', 'BLANK']):
            raise ValueError("must be one of enum values ('PR_BODY', 'COMMIT_MESSAGES', 'BLANK')")
        return value

    @field_validator('merge_commit_title')
    def merge_commit_title_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PR_TITLE', 'MERGE_MESSAGE']):
            raise ValueError("must be one of enum values ('PR_TITLE', 'MERGE_MESSAGE')")
        return value

    @field_validator('merge_commit_message')
    def merge_commit_message_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PR_BODY', 'PR_TITLE', 'BLANK']):
            raise ValueError("must be one of enum values ('PR_BODY', 'PR_TITLE', 'BLANK')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RepositoryWebhooksTemplateRepository from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of permissions
        if self.permissions:
            _dict['permissions'] = self.permissions.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RepositoryWebhooksTemplateRepository from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "name": obj.get("name"),
            "full_name": obj.get("full_name"),
            "owner": RepositoryWebhooksTemplateRepositoryOwner.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "private": obj.get("private"),
            "html_url": obj.get("html_url"),
            "description": obj.get("description"),
            "fork": obj.get("fork"),
            "url": obj.get("url"),
            "archive_url": obj.get("archive_url"),
            "assignees_url": obj.get("assignees_url"),
            "blobs_url": obj.get("blobs_url"),
            "branches_url": obj.get("branches_url"),
            "collaborators_url": obj.get("collaborators_url"),
            "comments_url": obj.get("comments_url"),
            "commits_url": obj.get("commits_url"),
            "compare_url": obj.get("compare_url"),
            "contents_url": obj.get("contents_url"),
            "contributors_url": obj.get("contributors_url"),
            "deployments_url": obj.get("deployments_url"),
            "downloads_url": obj.get("downloads_url"),
            "events_url": obj.get("events_url"),
            "forks_url": obj.get("forks_url"),
            "git_commits_url": obj.get("git_commits_url"),
            "git_refs_url": obj.get("git_refs_url"),
            "git_tags_url": obj.get("git_tags_url"),
            "git_url": obj.get("git_url"),
            "issue_comment_url": obj.get("issue_comment_url"),
            "issue_events_url": obj.get("issue_events_url"),
            "issues_url": obj.get("issues_url"),
            "keys_url": obj.get("keys_url"),
            "labels_url": obj.get("labels_url"),
            "languages_url": obj.get("languages_url"),
            "merges_url": obj.get("merges_url"),
            "milestones_url": obj.get("milestones_url"),
            "notifications_url": obj.get("notifications_url"),
            "pulls_url": obj.get("pulls_url"),
            "releases_url": obj.get("releases_url"),
            "ssh_url": obj.get("ssh_url"),
            "stargazers_url": obj.get("stargazers_url"),
            "statuses_url": obj.get("statuses_url"),
            "subscribers_url": obj.get("subscribers_url"),
            "subscription_url": obj.get("subscription_url"),
            "tags_url": obj.get("tags_url"),
            "teams_url": obj.get("teams_url"),
            "trees_url": obj.get("trees_url"),
            "clone_url": obj.get("clone_url"),
            "mirror_url": obj.get("mirror_url"),
            "hooks_url": obj.get("hooks_url"),
            "svn_url": obj.get("svn_url"),
            "homepage": obj.get("homepage"),
            "language": obj.get("language"),
            "forks_count": obj.get("forks_count"),
            "stargazers_count": obj.get("stargazers_count"),
            "watchers_count": obj.get("watchers_count"),
            "size": obj.get("size"),
            "default_branch": obj.get("default_branch"),
            "open_issues_count": obj.get("open_issues_count"),
            "is_template": obj.get("is_template"),
            "topics": obj.get("topics"),
            "has_issues": obj.get("has_issues"),
            "has_projects": obj.get("has_projects"),
            "has_wiki": obj.get("has_wiki"),
            "has_pages": obj.get("has_pages"),
            "has_downloads": obj.get("has_downloads"),
            "archived": obj.get("archived"),
            "disabled": obj.get("disabled"),
            "visibility": obj.get("visibility"),
            "pushed_at": obj.get("pushed_at"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "permissions": MinimalRepositoryPermissions.from_dict(obj["permissions"]) if obj.get("permissions") is not None else None,
            "allow_rebase_merge": obj.get("allow_rebase_merge"),
            "temp_clone_token": obj.get("temp_clone_token"),
            "allow_squash_merge": obj.get("allow_squash_merge"),
            "allow_auto_merge": obj.get("allow_auto_merge"),
            "delete_branch_on_merge": obj.get("delete_branch_on_merge"),
            "allow_update_branch": obj.get("allow_update_branch"),
            "use_squash_pr_title_as_default": obj.get("use_squash_pr_title_as_default"),
            "squash_merge_commit_title": obj.get("squash_merge_commit_title"),
            "squash_merge_commit_message": obj.get("squash_merge_commit_message"),
            "merge_commit_title": obj.get("merge_commit_title"),
            "merge_commit_message": obj.get("merge_commit_message"),
            "allow_merge_commit": obj.get("allow_merge_commit"),
            "subscribers_count": obj.get("subscribers_count"),
            "network_count": obj.get("network_count")
        })
        return _obj


