# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.nullable_integration import NullableIntegration
from devopso.clients.github.models.simple_user import SimpleUser
from devopso.clients.github.models.team import Team
from typing import Optional, Set
from typing_extensions import Self

class ReviewRequestRemovedIssueEvent(BaseModel):
    """
    Review Request Removed Issue Event
    """ # noqa: E501
    id: StrictInt
    node_id: StrictStr
    url: StrictStr
    actor: SimpleUser
    event: StrictStr
    commit_id: Optional[StrictStr]
    commit_url: Optional[StrictStr]
    created_at: StrictStr
    performed_via_github_app: Optional[NullableIntegration]
    review_requester: SimpleUser
    requested_team: Optional[Team] = None
    requested_reviewer: Optional[SimpleUser] = None
    __properties: ClassVar[List[str]] = ["id", "node_id", "url", "actor", "event", "commit_id", "commit_url", "created_at", "performed_via_github_app", "review_requester", "requested_team", "requested_reviewer"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReviewRequestRemovedIssueEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of actor
        if self.actor:
            _dict['actor'] = self.actor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of performed_via_github_app
        if self.performed_via_github_app:
            _dict['performed_via_github_app'] = self.performed_via_github_app.to_dict()
        # override the default output from pydantic by calling `to_dict()` of review_requester
        if self.review_requester:
            _dict['review_requester'] = self.review_requester.to_dict()
        # override the default output from pydantic by calling `to_dict()` of requested_team
        if self.requested_team:
            _dict['requested_team'] = self.requested_team.to_dict()
        # override the default output from pydantic by calling `to_dict()` of requested_reviewer
        if self.requested_reviewer:
            _dict['requested_reviewer'] = self.requested_reviewer.to_dict()
        # set to None if commit_id (nullable) is None
        # and model_fields_set contains the field
        if self.commit_id is None and "commit_id" in self.model_fields_set:
            _dict['commit_id'] = None

        # set to None if commit_url (nullable) is None
        # and model_fields_set contains the field
        if self.commit_url is None and "commit_url" in self.model_fields_set:
            _dict['commit_url'] = None

        # set to None if performed_via_github_app (nullable) is None
        # and model_fields_set contains the field
        if self.performed_via_github_app is None and "performed_via_github_app" in self.model_fields_set:
            _dict['performed_via_github_app'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReviewRequestRemovedIssueEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "url": obj.get("url"),
            "actor": SimpleUser.from_dict(obj["actor"]) if obj.get("actor") is not None else None,
            "event": obj.get("event"),
            "commit_id": obj.get("commit_id"),
            "commit_url": obj.get("commit_url"),
            "created_at": obj.get("created_at"),
            "performed_via_github_app": NullableIntegration.from_dict(obj["performed_via_github_app"]) if obj.get("performed_via_github_app") is not None else None,
            "review_requester": SimpleUser.from_dict(obj["review_requester"]) if obj.get("review_requester") is not None else None,
            "requested_team": Team.from_dict(obj["requested_team"]) if obj.get("requested_team") is not None else None,
            "requested_reviewer": SimpleUser.from_dict(obj["requested_reviewer"]) if obj.get("requested_reviewer") is not None else None
        })
        return _obj


