# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.rule_suite_rule_evaluations_inner import RuleSuiteRuleEvaluationsInner
from typing import Optional, Set
from typing_extensions import Self

class RuleSuite(BaseModel):
    """
    Response
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="The unique identifier of the rule insight.")
    actor_id: Optional[StrictInt] = Field(default=None, description="The number that identifies the user.")
    actor_name: Optional[StrictStr] = Field(default=None, description="The handle for the GitHub user account.")
    before_sha: Optional[StrictStr] = Field(default=None, description="The previous commit SHA of the ref.")
    after_sha: Optional[StrictStr] = Field(default=None, description="The new commit SHA of the ref.")
    ref: Optional[StrictStr] = Field(default=None, description="The ref name that the evaluation ran on.")
    repository_id: Optional[StrictInt] = Field(default=None, description="The ID of the repository associated with the rule evaluation.")
    repository_name: Optional[StrictStr] = Field(default=None, description="The name of the repository without the `.git` extension.")
    pushed_at: Optional[datetime] = None
    result: Optional[StrictStr] = Field(default=None, description="The result of the rule evaluations for rules with the `active` enforcement status.")
    evaluation_result: Optional[StrictStr] = Field(default=None, description="The result of the rule evaluations for rules with the `active` and `evaluate` enforcement statuses, demonstrating whether rules would pass or fail if all rules in the rule suite were `active`. Null if no rules with `evaluate` enforcement status were run.")
    rule_evaluations: Optional[List[RuleSuiteRuleEvaluationsInner]] = Field(default=None, description="Details on the evaluated rules.")
    __properties: ClassVar[List[str]] = ["id", "actor_id", "actor_name", "before_sha", "after_sha", "ref", "repository_id", "repository_name", "pushed_at", "result", "evaluation_result", "rule_evaluations"]

    @field_validator('result')
    def result_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['pass', 'fail', 'bypass']):
            raise ValueError("must be one of enum values ('pass', 'fail', 'bypass')")
        return value

    @field_validator('evaluation_result')
    def evaluation_result_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['pass', 'fail', 'bypass']):
            raise ValueError("must be one of enum values ('pass', 'fail', 'bypass')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RuleSuite from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in rule_evaluations (list)
        _items = []
        if self.rule_evaluations:
            for _item_rule_evaluations in self.rule_evaluations:
                if _item_rule_evaluations:
                    _items.append(_item_rule_evaluations.to_dict())
            _dict['rule_evaluations'] = _items
        # set to None if actor_id (nullable) is None
        # and model_fields_set contains the field
        if self.actor_id is None and "actor_id" in self.model_fields_set:
            _dict['actor_id'] = None

        # set to None if actor_name (nullable) is None
        # and model_fields_set contains the field
        if self.actor_name is None and "actor_name" in self.model_fields_set:
            _dict['actor_name'] = None

        # set to None if evaluation_result (nullable) is None
        # and model_fields_set contains the field
        if self.evaluation_result is None and "evaluation_result" in self.model_fields_set:
            _dict['evaluation_result'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RuleSuite from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "actor_id": obj.get("actor_id"),
            "actor_name": obj.get("actor_name"),
            "before_sha": obj.get("before_sha"),
            "after_sha": obj.get("after_sha"),
            "ref": obj.get("ref"),
            "repository_id": obj.get("repository_id"),
            "repository_name": obj.get("repository_name"),
            "pushed_at": obj.get("pushed_at"),
            "result": obj.get("result"),
            "evaluation_result": obj.get("evaluation_result"),
            "rule_evaluations": [RuleSuiteRuleEvaluationsInner.from_dict(_item) for _item in obj["rule_evaluations"]] if obj.get("rule_evaluations") is not None else None
        })
        return _obj


