# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.rule_suite_rule_evaluations_inner_rule_source import RuleSuiteRuleEvaluationsInnerRuleSource
from typing import Optional, Set
from typing_extensions import Self

class RuleSuiteRuleEvaluationsInner(BaseModel):
    """
    RuleSuiteRuleEvaluationsInner
    """ # noqa: E501
    rule_source: Optional[RuleSuiteRuleEvaluationsInnerRuleSource] = None
    enforcement: Optional[StrictStr] = Field(default=None, description="The enforcement level of this rule source.")
    result: Optional[StrictStr] = Field(default=None, description="The result of the evaluation of the individual rule.")
    rule_type: Optional[StrictStr] = Field(default=None, description="The type of rule.")
    details: Optional[StrictStr] = Field(default=None, description="The detailed failure message for the rule. Null if the rule passed.")
    __properties: ClassVar[List[str]] = ["rule_source", "enforcement", "result", "rule_type", "details"]

    @field_validator('enforcement')
    def enforcement_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['active', 'evaluate', 'deleted ruleset']):
            raise ValueError("must be one of enum values ('active', 'evaluate', 'deleted ruleset')")
        return value

    @field_validator('result')
    def result_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['pass', 'fail']):
            raise ValueError("must be one of enum values ('pass', 'fail')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RuleSuiteRuleEvaluationsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of rule_source
        if self.rule_source:
            _dict['rule_source'] = self.rule_source.to_dict()
        # set to None if details (nullable) is None
        # and model_fields_set contains the field
        if self.details is None and "details" in self.model_fields_set:
            _dict['details'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RuleSuiteRuleEvaluationsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "rule_source": RuleSuiteRuleEvaluationsInnerRuleSource.from_dict(obj["rule_source"]) if obj.get("rule_source") is not None else None,
            "enforcement": obj.get("enforcement"),
            "result": obj.get("result"),
            "rule_type": obj.get("rule_type"),
            "details": obj.get("details")
        })
        return _obj


