# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class RuleSuitesInner(BaseModel):
    """
    RuleSuitesInner
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="The unique identifier of the rule insight.")
    actor_id: Optional[StrictInt] = Field(default=None, description="The number that identifies the user.")
    actor_name: Optional[StrictStr] = Field(default=None, description="The handle for the GitHub user account.")
    before_sha: Optional[StrictStr] = Field(default=None, description="The first commit sha before the push evaluation.")
    after_sha: Optional[StrictStr] = Field(default=None, description="The last commit sha in the push evaluation.")
    ref: Optional[StrictStr] = Field(default=None, description="The ref name that the evaluation ran on.")
    repository_id: Optional[StrictInt] = Field(default=None, description="The ID of the repository associated with the rule evaluation.")
    repository_name: Optional[StrictStr] = Field(default=None, description="The name of the repository without the `.git` extension.")
    pushed_at: Optional[datetime] = None
    result: Optional[StrictStr] = Field(default=None, description="The result of the rule evaluations for rules with the `active` enforcement status.")
    evaluation_result: Optional[StrictStr] = Field(default=None, description="The result of the rule evaluations for rules with the `active` and `evaluate` enforcement statuses, demonstrating whether rules would pass or fail if all rules in the rule suite were `active`.")
    __properties: ClassVar[List[str]] = ["id", "actor_id", "actor_name", "before_sha", "after_sha", "ref", "repository_id", "repository_name", "pushed_at", "result", "evaluation_result"]

    @field_validator('result')
    def result_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['pass', 'fail', 'bypass']):
            raise ValueError("must be one of enum values ('pass', 'fail', 'bypass')")
        return value

    @field_validator('evaluation_result')
    def evaluation_result_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['pass', 'fail', 'bypass']):
            raise ValueError("must be one of enum values ('pass', 'fail', 'bypass')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RuleSuitesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RuleSuitesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "actor_id": obj.get("actor_id"),
            "actor_name": obj.get("actor_name"),
            "before_sha": obj.get("before_sha"),
            "after_sha": obj.get("after_sha"),
            "ref": obj.get("ref"),
            "repository_id": obj.get("repository_id"),
            "repository_name": obj.get("repository_name"),
            "pushed_at": obj.get("pushed_at"),
            "result": obj.get("result"),
            "evaluation_result": obj.get("evaluation_result")
        })
        return _obj


