# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.runner_label import RunnerLabel
from typing import Optional, Set
from typing_extensions import Self

class Runner(BaseModel):
    """
    A self hosted runner
    """ # noqa: E501
    id: StrictInt = Field(description="The ID of the runner.")
    runner_group_id: Optional[StrictInt] = Field(default=None, description="The ID of the runner group.")
    name: StrictStr = Field(description="The name of the runner.")
    os: StrictStr = Field(description="The Operating System of the runner.")
    status: StrictStr = Field(description="The status of the runner.")
    busy: StrictBool
    labels: List[RunnerLabel]
    ephemeral: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["id", "runner_group_id", "name", "os", "status", "busy", "labels", "ephemeral"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Runner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item_labels in self.labels:
                if _item_labels:
                    _items.append(_item_labels.to_dict())
            _dict['labels'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Runner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "runner_group_id": obj.get("runner_group_id"),
            "name": obj.get("name"),
            "os": obj.get("os"),
            "status": obj.get("status"),
            "busy": obj.get("busy"),
            "labels": [RunnerLabel.from_dict(_item) for _item in obj["labels"]] if obj.get("labels") is not None else None,
            "ephemeral": obj.get("ephemeral")
        })
        return _obj


