# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class RunnerGroupsOrg(BaseModel):
    """
    RunnerGroupsOrg
    """ # noqa: E501
    id: Union[StrictFloat, StrictInt]
    name: StrictStr
    visibility: StrictStr
    default: StrictBool
    selected_repositories_url: Optional[StrictStr] = Field(default=None, description="Link to the selected repositories resource for this runner group. Not present unless visibility was set to `selected`")
    runners_url: StrictStr
    hosted_runners_url: Optional[StrictStr] = None
    network_configuration_id: Optional[StrictStr] = Field(default=None, description="The identifier of a hosted compute network configuration.")
    inherited: StrictBool
    inherited_allows_public_repositories: Optional[StrictBool] = None
    allows_public_repositories: StrictBool
    workflow_restrictions_read_only: Optional[StrictBool] = Field(default=False, description="If `true`, the `restricted_to_workflows` and `selected_workflows` fields cannot be modified.")
    restricted_to_workflows: Optional[StrictBool] = Field(default=False, description="If `true`, the runner group will be restricted to running only the workflows specified in the `selected_workflows` array.")
    selected_workflows: Optional[List[StrictStr]] = Field(default=None, description="List of workflows the runner group should be allowed to run. This setting will be ignored unless `restricted_to_workflows` is set to `true`.")
    __properties: ClassVar[List[str]] = ["id", "name", "visibility", "default", "selected_repositories_url", "runners_url", "hosted_runners_url", "network_configuration_id", "inherited", "inherited_allows_public_repositories", "allows_public_repositories", "workflow_restrictions_read_only", "restricted_to_workflows", "selected_workflows"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RunnerGroupsOrg from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RunnerGroupsOrg from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "visibility": obj.get("visibility"),
            "default": obj.get("default"),
            "selected_repositories_url": obj.get("selected_repositories_url"),
            "runners_url": obj.get("runners_url"),
            "hosted_runners_url": obj.get("hosted_runners_url"),
            "network_configuration_id": obj.get("network_configuration_id"),
            "inherited": obj.get("inherited"),
            "inherited_allows_public_repositories": obj.get("inherited_allows_public_repositories"),
            "allows_public_repositories": obj.get("allows_public_repositories"),
            "workflow_restrictions_read_only": obj.get("workflow_restrictions_read_only") if obj.get("workflow_restrictions_read_only") is not None else False,
            "restricted_to_workflows": obj.get("restricted_to_workflows") if obj.get("restricted_to_workflows") is not None else False,
            "selected_workflows": obj.get("selected_workflows")
        })
        return _obj


