# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.secret_scanning_pattern_override import SecretScanningPatternOverride
from typing import Optional, Set
from typing_extensions import Self

class SecretScanningPatternConfiguration(BaseModel):
    """
    A collection of secret scanning patterns and their settings related to push protection.
    """ # noqa: E501
    pattern_config_version: Optional[StrictStr] = Field(default=None, description="The version of the entity. This is used to confirm you're updating the current version of the entity and mitigate unintentionally overriding someone else's update.")
    provider_pattern_overrides: Optional[List[SecretScanningPatternOverride]] = Field(default=None, description="Overrides for partner patterns.")
    custom_pattern_overrides: Optional[List[SecretScanningPatternOverride]] = Field(default=None, description="Overrides for custom patterns defined by the organization.")
    __properties: ClassVar[List[str]] = ["pattern_config_version", "provider_pattern_overrides", "custom_pattern_overrides"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SecretScanningPatternConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in provider_pattern_overrides (list)
        _items = []
        if self.provider_pattern_overrides:
            for _item_provider_pattern_overrides in self.provider_pattern_overrides:
                if _item_provider_pattern_overrides:
                    _items.append(_item_provider_pattern_overrides.to_dict())
            _dict['provider_pattern_overrides'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in custom_pattern_overrides (list)
        _items = []
        if self.custom_pattern_overrides:
            for _item_custom_pattern_overrides in self.custom_pattern_overrides:
                if _item_custom_pattern_overrides:
                    _items.append(_item_custom_pattern_overrides.to_dict())
            _dict['custom_pattern_overrides'] = _items
        # set to None if pattern_config_version (nullable) is None
        # and model_fields_set contains the field
        if self.pattern_config_version is None and "pattern_config_version" in self.model_fields_set:
            _dict['pattern_config_version'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SecretScanningPatternConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pattern_config_version": obj.get("pattern_config_version"),
            "provider_pattern_overrides": [SecretScanningPatternOverride.from_dict(_item) for _item in obj["provider_pattern_overrides"]] if obj.get("provider_pattern_overrides") is not None else None,
            "custom_pattern_overrides": [SecretScanningPatternOverride.from_dict(_item) for _item in obj["custom_pattern_overrides"]] if obj.get("custom_pattern_overrides") is not None else None
        })
        return _obj


