# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SecretScanningPatternOverride(BaseModel):
    """
    SecretScanningPatternOverride
    """ # noqa: E501
    token_type: Optional[StrictStr] = Field(default=None, description="The ID of the pattern.")
    custom_pattern_version: Optional[StrictStr] = Field(default=None, description="The version of this pattern if it's a custom pattern.")
    slug: Optional[StrictStr] = Field(default=None, description="The slug of the pattern.")
    display_name: Optional[StrictStr] = Field(default=None, description="The user-friendly name for the pattern.")
    alert_total: Optional[StrictInt] = Field(default=None, description="The total number of alerts generated by this pattern.")
    alert_total_percentage: Optional[StrictInt] = Field(default=None, description="The percentage of all alerts that this pattern represents, rounded to the nearest integer.")
    false_positives: Optional[StrictInt] = Field(default=None, description="The number of false positive alerts generated by this pattern.")
    false_positive_rate: Optional[StrictInt] = Field(default=None, description="The percentage of alerts from this pattern that are false positives, rounded to the nearest integer.")
    bypass_rate: Optional[StrictInt] = Field(default=None, description="The percentage of blocks for this pattern that were bypassed, rounded to the nearest integer.")
    default_setting: Optional[StrictStr] = Field(default=None, description="The default push protection setting for this pattern.")
    enterprise_setting: Optional[StrictStr] = Field(default=None, description="The push protection setting for this pattern set at the enterprise level. Only present for partner patterns when the organization has a parent enterprise.")
    setting: Optional[StrictStr] = Field(default=None, description="The current push protection setting for this pattern. If this is `not-set`, then it inherits either the enterprise setting if it exists or the default setting.")
    __properties: ClassVar[List[str]] = ["token_type", "custom_pattern_version", "slug", "display_name", "alert_total", "alert_total_percentage", "false_positives", "false_positive_rate", "bypass_rate", "default_setting", "enterprise_setting", "setting"]

    @field_validator('default_setting')
    def default_setting_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['disabled', 'enabled']):
            raise ValueError("must be one of enum values ('disabled', 'enabled')")
        return value

    @field_validator('enterprise_setting')
    def enterprise_setting_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['not-set', 'disabled', 'enabled']):
            raise ValueError("must be one of enum values ('not-set', 'disabled', 'enabled')")
        return value

    @field_validator('setting')
    def setting_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['not-set', 'disabled', 'enabled']):
            raise ValueError("must be one of enum values ('not-set', 'disabled', 'enabled')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SecretScanningPatternOverride from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if custom_pattern_version (nullable) is None
        # and model_fields_set contains the field
        if self.custom_pattern_version is None and "custom_pattern_version" in self.model_fields_set:
            _dict['custom_pattern_version'] = None

        # set to None if enterprise_setting (nullable) is None
        # and model_fields_set contains the field
        if self.enterprise_setting is None and "enterprise_setting" in self.model_fields_set:
            _dict['enterprise_setting'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SecretScanningPatternOverride from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "token_type": obj.get("token_type"),
            "custom_pattern_version": obj.get("custom_pattern_version"),
            "slug": obj.get("slug"),
            "display_name": obj.get("display_name"),
            "alert_total": obj.get("alert_total"),
            "alert_total_percentage": obj.get("alert_total_percentage"),
            "false_positives": obj.get("false_positives"),
            "false_positive_rate": obj.get("false_positive_rate"),
            "bypass_rate": obj.get("bypass_rate"),
            "default_setting": obj.get("default_setting"),
            "enterprise_setting": obj.get("enterprise_setting"),
            "setting": obj.get("setting")
        })
        return _obj


