# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.secret_scanning_scan import SecretScanningScan
from devopso.clients.github.models.secret_scanning_scan_history_custom_pattern_backfill_scans_inner import SecretScanningScanHistoryCustomPatternBackfillScansInner
from typing import Optional, Set
from typing_extensions import Self

class SecretScanningScanHistory(BaseModel):
    """
    SecretScanningScanHistory
    """ # noqa: E501
    incremental_scans: Optional[List[SecretScanningScan]] = None
    pattern_update_scans: Optional[List[SecretScanningScan]] = None
    backfill_scans: Optional[List[SecretScanningScan]] = None
    custom_pattern_backfill_scans: Optional[List[SecretScanningScanHistoryCustomPatternBackfillScansInner]] = None
    __properties: ClassVar[List[str]] = ["incremental_scans", "pattern_update_scans", "backfill_scans", "custom_pattern_backfill_scans"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SecretScanningScanHistory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in incremental_scans (list)
        _items = []
        if self.incremental_scans:
            for _item_incremental_scans in self.incremental_scans:
                if _item_incremental_scans:
                    _items.append(_item_incremental_scans.to_dict())
            _dict['incremental_scans'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in pattern_update_scans (list)
        _items = []
        if self.pattern_update_scans:
            for _item_pattern_update_scans in self.pattern_update_scans:
                if _item_pattern_update_scans:
                    _items.append(_item_pattern_update_scans.to_dict())
            _dict['pattern_update_scans'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in backfill_scans (list)
        _items = []
        if self.backfill_scans:
            for _item_backfill_scans in self.backfill_scans:
                if _item_backfill_scans:
                    _items.append(_item_backfill_scans.to_dict())
            _dict['backfill_scans'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in custom_pattern_backfill_scans (list)
        _items = []
        if self.custom_pattern_backfill_scans:
            for _item_custom_pattern_backfill_scans in self.custom_pattern_backfill_scans:
                if _item_custom_pattern_backfill_scans:
                    _items.append(_item_custom_pattern_backfill_scans.to_dict())
            _dict['custom_pattern_backfill_scans'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SecretScanningScanHistory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "incremental_scans": [SecretScanningScan.from_dict(_item) for _item in obj["incremental_scans"]] if obj.get("incremental_scans") is not None else None,
            "pattern_update_scans": [SecretScanningScan.from_dict(_item) for _item in obj["pattern_update_scans"]] if obj.get("pattern_update_scans") is not None else None,
            "backfill_scans": [SecretScanningScan.from_dict(_item) for _item in obj["backfill_scans"]] if obj.get("backfill_scans") is not None else None,
            "custom_pattern_backfill_scans": [SecretScanningScanHistoryCustomPatternBackfillScansInner.from_dict(_item) for _item in obj["custom_pattern_backfill_scans"]] if obj.get("custom_pattern_backfill_scans") is not None else None
        })
        return _obj


