# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.secret_scanning_alert_resolution import SecretScanningAlertResolution
from devopso.clients.github.models.secret_scanning_alert_state import SecretScanningAlertState
from typing import Optional, Set
from typing_extensions import Self

class SecretScanningUpdateAlertRequest(BaseModel):
    """
    SecretScanningUpdateAlertRequest
    """ # noqa: E501
    state: SecretScanningAlertState
    resolution: Optional[SecretScanningAlertResolution] = None
    resolution_comment: Optional[StrictStr] = Field(default=None, description="An optional comment when closing or reopening an alert. Cannot be updated or deleted.")
    __properties: ClassVar[List[str]] = ["state", "resolution", "resolution_comment"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SecretScanningUpdateAlertRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if resolution (nullable) is None
        # and model_fields_set contains the field
        if self.resolution is None and "resolution" in self.model_fields_set:
            _dict['resolution'] = None

        # set to None if resolution_comment (nullable) is None
        # and model_fields_set contains the field
        if self.resolution_comment is None and "resolution_comment" in self.model_fields_set:
            _dict['resolution_comment'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SecretScanningUpdateAlertRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "state": obj.get("state"),
            "resolution": obj.get("resolution"),
            "resolution_comment": obj.get("resolution_comment")
        })
        return _obj


