# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.integration import Integration
from devopso.clients.github.models.minimal_repository import MinimalRepository
from devopso.clients.github.models.pull_request_minimal import PullRequestMinimal
from typing import Optional, Set
from typing_extensions import Self

class SimpleCheckSuite(BaseModel):
    """
    A suite of checks performed on the code of a given code change
    """ # noqa: E501
    after: Optional[StrictStr] = None
    app: Optional[Integration] = None
    before: Optional[StrictStr] = None
    conclusion: Optional[StrictStr] = None
    created_at: Optional[datetime] = None
    head_branch: Optional[StrictStr] = None
    head_sha: Optional[StrictStr] = Field(default=None, description="The SHA of the head commit that is being checked.")
    id: Optional[StrictInt] = None
    node_id: Optional[StrictStr] = None
    pull_requests: Optional[List[PullRequestMinimal]] = None
    repository: Optional[MinimalRepository] = None
    status: Optional[StrictStr] = None
    updated_at: Optional[datetime] = None
    url: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["after", "app", "before", "conclusion", "created_at", "head_branch", "head_sha", "id", "node_id", "pull_requests", "repository", "status", "updated_at", "url"]

    @field_validator('conclusion')
    def conclusion_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['success', 'failure', 'neutral', 'cancelled', 'skipped', 'timed_out', 'action_required', 'stale', 'startup_failure']):
            raise ValueError("must be one of enum values ('success', 'failure', 'neutral', 'cancelled', 'skipped', 'timed_out', 'action_required', 'stale', 'startup_failure')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['queued', 'in_progress', 'completed', 'pending', 'waiting']):
            raise ValueError("must be one of enum values ('queued', 'in_progress', 'completed', 'pending', 'waiting')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SimpleCheckSuite from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of app
        if self.app:
            _dict['app'] = self.app.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in pull_requests (list)
        _items = []
        if self.pull_requests:
            for _item_pull_requests in self.pull_requests:
                if _item_pull_requests:
                    _items.append(_item_pull_requests.to_dict())
            _dict['pull_requests'] = _items
        # override the default output from pydantic by calling `to_dict()` of repository
        if self.repository:
            _dict['repository'] = self.repository.to_dict()
        # set to None if after (nullable) is None
        # and model_fields_set contains the field
        if self.after is None and "after" in self.model_fields_set:
            _dict['after'] = None

        # set to None if app (nullable) is None
        # and model_fields_set contains the field
        if self.app is None and "app" in self.model_fields_set:
            _dict['app'] = None

        # set to None if before (nullable) is None
        # and model_fields_set contains the field
        if self.before is None and "before" in self.model_fields_set:
            _dict['before'] = None

        # set to None if conclusion (nullable) is None
        # and model_fields_set contains the field
        if self.conclusion is None and "conclusion" in self.model_fields_set:
            _dict['conclusion'] = None

        # set to None if head_branch (nullable) is None
        # and model_fields_set contains the field
        if self.head_branch is None and "head_branch" in self.model_fields_set:
            _dict['head_branch'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SimpleCheckSuite from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "after": obj.get("after"),
            "app": Integration.from_dict(obj["app"]) if obj.get("app") is not None else None,
            "before": obj.get("before"),
            "conclusion": obj.get("conclusion"),
            "created_at": obj.get("created_at"),
            "head_branch": obj.get("head_branch"),
            "head_sha": obj.get("head_sha"),
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "pull_requests": [PullRequestMinimal.from_dict(_item) for _item in obj["pull_requests"]] if obj.get("pull_requests") is not None else None,
            "repository": MinimalRepository.from_dict(obj["repository"]) if obj.get("repository") is not None else None,
            "status": obj.get("status"),
            "updated_at": obj.get("updated_at"),
            "url": obj.get("url")
        })
        return _obj


