# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.simple_classroom import SimpleClassroom
from typing import Optional, Set
from typing_extensions import Self

class SimpleClassroomAssignment(BaseModel):
    """
    A GitHub Classroom assignment
    """ # noqa: E501
    id: StrictInt = Field(description="Unique identifier of the repository.")
    public_repo: StrictBool = Field(description="Whether an accepted assignment creates a public repository.")
    title: StrictStr = Field(description="Assignment title.")
    type: StrictStr = Field(description="Whether it's a Group Assignment or Individual Assignment.")
    invite_link: StrictStr = Field(description="The link that a student can use to accept the assignment.")
    invitations_enabled: StrictBool = Field(description="Whether the invitation link is enabled. Visiting an enabled invitation link will accept the assignment.")
    slug: StrictStr = Field(description="Sluggified name of the assignment.")
    students_are_repo_admins: StrictBool = Field(description="Whether students are admins on created repository on accepted assignment.")
    feedback_pull_requests_enabled: StrictBool = Field(description="Whether feedback pull request will be created on assignment acceptance.")
    max_teams: Optional[StrictInt] = Field(default=None, description="The maximum allowable teams for the assignment.")
    max_members: Optional[StrictInt] = Field(default=None, description="The maximum allowable members per team.")
    editor: StrictStr = Field(description="The selected editor for the assignment.")
    accepted: StrictInt = Field(description="The number of students that have accepted the assignment.")
    submitted: StrictInt = Field(description="The number of students that have submitted the assignment.")
    passing: StrictInt = Field(description="The number of students that have passed the assignment.")
    language: StrictStr = Field(description="The programming language used in the assignment.")
    deadline: Optional[datetime] = Field(description="The time at which the assignment is due.")
    classroom: SimpleClassroom
    __properties: ClassVar[List[str]] = ["id", "public_repo", "title", "type", "invite_link", "invitations_enabled", "slug", "students_are_repo_admins", "feedback_pull_requests_enabled", "max_teams", "max_members", "editor", "accepted", "submitted", "passing", "language", "deadline", "classroom"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['individual', 'group']):
            raise ValueError("must be one of enum values ('individual', 'group')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SimpleClassroomAssignment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of classroom
        if self.classroom:
            _dict['classroom'] = self.classroom.to_dict()
        # set to None if max_teams (nullable) is None
        # and model_fields_set contains the field
        if self.max_teams is None and "max_teams" in self.model_fields_set:
            _dict['max_teams'] = None

        # set to None if max_members (nullable) is None
        # and model_fields_set contains the field
        if self.max_members is None and "max_members" in self.model_fields_set:
            _dict['max_members'] = None

        # set to None if deadline (nullable) is None
        # and model_fields_set contains the field
        if self.deadline is None and "deadline" in self.model_fields_set:
            _dict['deadline'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SimpleClassroomAssignment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "public_repo": obj.get("public_repo"),
            "title": obj.get("title"),
            "type": obj.get("type"),
            "invite_link": obj.get("invite_link"),
            "invitations_enabled": obj.get("invitations_enabled"),
            "slug": obj.get("slug"),
            "students_are_repo_admins": obj.get("students_are_repo_admins"),
            "feedback_pull_requests_enabled": obj.get("feedback_pull_requests_enabled"),
            "max_teams": obj.get("max_teams"),
            "max_members": obj.get("max_members"),
            "editor": obj.get("editor"),
            "accepted": obj.get("accepted"),
            "submitted": obj.get("submitted"),
            "passing": obj.get("passing"),
            "language": obj.get("language"),
            "deadline": obj.get("deadline"),
            "classroom": SimpleClassroom.from_dict(obj["classroom"]) if obj.get("classroom") is not None else None
        })
        return _obj


