# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.github.models.manifest import Manifest
from devopso.clients.github.models.metadata_value import MetadataValue
from devopso.clients.github.models.snapshot_detector import SnapshotDetector
from devopso.clients.github.models.snapshot_job import SnapshotJob
from typing import Optional, Set
from typing_extensions import Self

class Snapshot(BaseModel):
    """
    Create a new snapshot of a repository's dependencies.
    """ # noqa: E501
    version: StrictInt = Field(description="The version of the repository snapshot submission.")
    job: SnapshotJob
    sha: Annotated[str, Field(min_length=40, strict=True, max_length=40)] = Field(description="The commit SHA associated with this dependency snapshot. Maximum length: 40 characters.")
    ref: Annotated[str, Field(strict=True)] = Field(description="The repository branch that triggered this snapshot.")
    detector: SnapshotDetector
    metadata: Optional[Dict[str, Optional[MetadataValue]]] = Field(default=None, description="User-defined metadata to store domain-specific information limited to 8 keys with scalar values.")
    manifests: Optional[Dict[str, Manifest]] = Field(default=None, description="A collection of package manifests, which are a collection of related dependencies declared in a file or representing a logical group of dependencies.")
    scanned: datetime = Field(description="The time at which the snapshot was scanned.")
    __properties: ClassVar[List[str]] = ["version", "job", "sha", "ref", "detector", "metadata", "manifests", "scanned"]

    @field_validator('ref')
    def ref_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^refs\/", value):
            raise ValueError(r"must validate the regular expression /^refs\//")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Snapshot from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of job
        if self.job:
            _dict['job'] = self.job.to_dict()
        # override the default output from pydantic by calling `to_dict()` of detector
        if self.detector:
            _dict['detector'] = self.detector.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in metadata (dict)
        _field_dict = {}
        if self.metadata:
            for _key_metadata in self.metadata:
                if self.metadata[_key_metadata]:
                    _field_dict[_key_metadata] = self.metadata[_key_metadata].to_dict()
            _dict['metadata'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in manifests (dict)
        _field_dict = {}
        if self.manifests:
            for _key_manifests in self.manifests:
                if self.manifests[_key_manifests]:
                    _field_dict[_key_manifests] = self.manifests[_key_manifests].to_dict()
            _dict['manifests'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Snapshot from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "version": obj.get("version"),
            "job": SnapshotJob.from_dict(obj["job"]) if obj.get("job") is not None else None,
            "sha": obj.get("sha"),
            "ref": obj.get("ref"),
            "detector": SnapshotDetector.from_dict(obj["detector"]) if obj.get("detector") is not None else None,
            "metadata": dict(
                (_k, MetadataValue.from_dict(_v))
                for _k, _v in obj["metadata"].items()
            )
            if obj.get("metadata") is not None
            else None,
            "manifests": dict(
                (_k, Manifest.from_dict(_v))
                for _k, _v in obj["manifests"].items()
            )
            if obj.get("manifests") is not None
            else None,
            "scanned": obj.get("scanned")
        })
        return _obj


