# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SponsorshipTier(BaseModel):
    """
    The `tier_changed` and `pending_tier_change` will include the original tier before the change or pending change. For more information, see the pending tier change payload.
    """ # noqa: E501
    created_at: StrictStr
    description: StrictStr
    is_custom_ammount: Optional[StrictBool] = None
    is_custom_amount: Optional[StrictBool] = None
    is_one_time: StrictBool
    monthly_price_in_cents: StrictInt
    monthly_price_in_dollars: StrictInt
    name: StrictStr
    node_id: StrictStr
    __properties: ClassVar[List[str]] = ["created_at", "description", "is_custom_ammount", "is_custom_amount", "is_one_time", "monthly_price_in_cents", "monthly_price_in_dollars", "name", "node_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SponsorshipTier from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SponsorshipTier from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "description": obj.get("description"),
            "is_custom_ammount": obj.get("is_custom_ammount"),
            "is_custom_amount": obj.get("is_custom_amount"),
            "is_one_time": obj.get("is_one_time"),
            "monthly_price_in_cents": obj.get("monthly_price_in_cents"),
            "monthly_price_in_dollars": obj.get("monthly_price_in_dollars"),
            "name": obj.get("name"),
            "node_id": obj.get("node_id")
        })
        return _obj


