# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.nullable_team_simple import NullableTeamSimple
from devopso.clients.github.models.team_organization import TeamOrganization
from typing import Optional, Set
from typing_extensions import Self

class TeamFull(BaseModel):
    """
    Groups of organization members that gives permissions on specified repositories.
    """ # noqa: E501
    id: StrictInt = Field(description="Unique identifier of the team")
    node_id: StrictStr
    url: StrictStr = Field(description="URL for the team")
    html_url: StrictStr
    name: StrictStr = Field(description="Name of the team")
    slug: StrictStr
    description: Optional[StrictStr]
    privacy: Optional[StrictStr] = Field(default=None, description="The level of privacy this team should have")
    notification_setting: Optional[StrictStr] = Field(default=None, description="The notification setting the team has set")
    permission: StrictStr = Field(description="Permission that the team will have for its repositories")
    members_url: StrictStr
    repositories_url: StrictStr
    parent: Optional[NullableTeamSimple] = None
    members_count: StrictInt
    repos_count: StrictInt
    created_at: datetime
    updated_at: datetime
    organization: TeamOrganization
    ldap_dn: Optional[StrictStr] = Field(default=None, description="The [distinguished name](https://www.ldap.com/ldap-dns-and-rdns) (DN) of the LDAP entry to map to a team.")
    type: StrictStr = Field(description="The ownership type of the team")
    organization_id: Optional[StrictInt] = Field(default=None, description="Unique identifier of the organization to which this team belongs")
    enterprise_id: Optional[StrictInt] = Field(default=None, description="Unique identifier of the enterprise to which this team belongs")
    __properties: ClassVar[List[str]] = ["id", "node_id", "url", "html_url", "name", "slug", "description", "privacy", "notification_setting", "permission", "members_url", "repositories_url", "parent", "members_count", "repos_count", "created_at", "updated_at", "organization", "ldap_dn", "type", "organization_id", "enterprise_id"]

    @field_validator('privacy')
    def privacy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['closed', 'secret']):
            raise ValueError("must be one of enum values ('closed', 'secret')")
        return value

    @field_validator('notification_setting')
    def notification_setting_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['notifications_enabled', 'notifications_disabled']):
            raise ValueError("must be one of enum values ('notifications_enabled', 'notifications_disabled')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['enterprise', 'organization']):
            raise ValueError("must be one of enum values ('enterprise', 'organization')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TeamFull from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of parent
        if self.parent:
            _dict['parent'] = self.parent.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict['organization'] = self.organization.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if parent (nullable) is None
        # and model_fields_set contains the field
        if self.parent is None and "parent" in self.model_fields_set:
            _dict['parent'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TeamFull from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "url": obj.get("url"),
            "html_url": obj.get("html_url"),
            "name": obj.get("name"),
            "slug": obj.get("slug"),
            "description": obj.get("description"),
            "privacy": obj.get("privacy"),
            "notification_setting": obj.get("notification_setting"),
            "permission": obj.get("permission"),
            "members_url": obj.get("members_url"),
            "repositories_url": obj.get("repositories_url"),
            "parent": NullableTeamSimple.from_dict(obj["parent"]) if obj.get("parent") is not None else None,
            "members_count": obj.get("members_count"),
            "repos_count": obj.get("repos_count"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "organization": TeamOrganization.from_dict(obj["organization"]) if obj.get("organization") is not None else None,
            "ldap_dn": obj.get("ldap_dn"),
            "type": obj.get("type"),
            "organization_id": obj.get("organization_id"),
            "enterprise_id": obj.get("enterprise_id")
        })
        return _obj


