# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.organization_full_plan import OrganizationFullPlan
from typing import Optional, Set
from typing_extensions import Self

class TeamOrganization(BaseModel):
    """
    Team Organization
    """ # noqa: E501
    login: StrictStr
    id: StrictInt
    node_id: StrictStr
    url: StrictStr
    repos_url: StrictStr
    events_url: StrictStr
    hooks_url: StrictStr
    issues_url: StrictStr
    members_url: StrictStr
    public_members_url: StrictStr
    avatar_url: StrictStr
    description: Optional[StrictStr]
    name: Optional[StrictStr] = None
    company: Optional[StrictStr] = None
    blog: Optional[StrictStr] = None
    location: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    twitter_username: Optional[StrictStr] = None
    is_verified: Optional[StrictBool] = None
    has_organization_projects: StrictBool
    has_repository_projects: StrictBool
    public_repos: StrictInt
    public_gists: StrictInt
    followers: StrictInt
    following: StrictInt
    html_url: StrictStr
    created_at: datetime
    type: StrictStr
    total_private_repos: Optional[StrictInt] = None
    owned_private_repos: Optional[StrictInt] = None
    private_gists: Optional[StrictInt] = None
    disk_usage: Optional[StrictInt] = None
    collaborators: Optional[StrictInt] = None
    billing_email: Optional[StrictStr] = None
    plan: Optional[OrganizationFullPlan] = None
    default_repository_permission: Optional[StrictStr] = None
    members_can_create_repositories: Optional[StrictBool] = None
    two_factor_requirement_enabled: Optional[StrictBool] = None
    members_allowed_repository_creation_type: Optional[StrictStr] = None
    members_can_create_public_repositories: Optional[StrictBool] = None
    members_can_create_private_repositories: Optional[StrictBool] = None
    members_can_create_internal_repositories: Optional[StrictBool] = None
    members_can_create_pages: Optional[StrictBool] = None
    members_can_create_public_pages: Optional[StrictBool] = None
    members_can_create_private_pages: Optional[StrictBool] = None
    members_can_fork_private_repositories: Optional[StrictBool] = None
    web_commit_signoff_required: Optional[StrictBool] = None
    updated_at: datetime
    archived_at: Optional[datetime]
    __properties: ClassVar[List[str]] = ["login", "id", "node_id", "url", "repos_url", "events_url", "hooks_url", "issues_url", "members_url", "public_members_url", "avatar_url", "description", "name", "company", "blog", "location", "email", "twitter_username", "is_verified", "has_organization_projects", "has_repository_projects", "public_repos", "public_gists", "followers", "following", "html_url", "created_at", "type", "total_private_repos", "owned_private_repos", "private_gists", "disk_usage", "collaborators", "billing_email", "plan", "default_repository_permission", "members_can_create_repositories", "two_factor_requirement_enabled", "members_allowed_repository_creation_type", "members_can_create_public_repositories", "members_can_create_private_repositories", "members_can_create_internal_repositories", "members_can_create_pages", "members_can_create_public_pages", "members_can_create_private_pages", "members_can_fork_private_repositories", "web_commit_signoff_required", "updated_at", "archived_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TeamOrganization from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of plan
        if self.plan:
            _dict['plan'] = self.plan.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if twitter_username (nullable) is None
        # and model_fields_set contains the field
        if self.twitter_username is None and "twitter_username" in self.model_fields_set:
            _dict['twitter_username'] = None

        # set to None if private_gists (nullable) is None
        # and model_fields_set contains the field
        if self.private_gists is None and "private_gists" in self.model_fields_set:
            _dict['private_gists'] = None

        # set to None if disk_usage (nullable) is None
        # and model_fields_set contains the field
        if self.disk_usage is None and "disk_usage" in self.model_fields_set:
            _dict['disk_usage'] = None

        # set to None if collaborators (nullable) is None
        # and model_fields_set contains the field
        if self.collaborators is None and "collaborators" in self.model_fields_set:
            _dict['collaborators'] = None

        # set to None if billing_email (nullable) is None
        # and model_fields_set contains the field
        if self.billing_email is None and "billing_email" in self.model_fields_set:
            _dict['billing_email'] = None

        # set to None if default_repository_permission (nullable) is None
        # and model_fields_set contains the field
        if self.default_repository_permission is None and "default_repository_permission" in self.model_fields_set:
            _dict['default_repository_permission'] = None

        # set to None if members_can_create_repositories (nullable) is None
        # and model_fields_set contains the field
        if self.members_can_create_repositories is None and "members_can_create_repositories" in self.model_fields_set:
            _dict['members_can_create_repositories'] = None

        # set to None if two_factor_requirement_enabled (nullable) is None
        # and model_fields_set contains the field
        if self.two_factor_requirement_enabled is None and "two_factor_requirement_enabled" in self.model_fields_set:
            _dict['two_factor_requirement_enabled'] = None

        # set to None if members_can_fork_private_repositories (nullable) is None
        # and model_fields_set contains the field
        if self.members_can_fork_private_repositories is None and "members_can_fork_private_repositories" in self.model_fields_set:
            _dict['members_can_fork_private_repositories'] = None

        # set to None if archived_at (nullable) is None
        # and model_fields_set contains the field
        if self.archived_at is None and "archived_at" in self.model_fields_set:
            _dict['archived_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TeamOrganization from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "login": obj.get("login"),
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "url": obj.get("url"),
            "repos_url": obj.get("repos_url"),
            "events_url": obj.get("events_url"),
            "hooks_url": obj.get("hooks_url"),
            "issues_url": obj.get("issues_url"),
            "members_url": obj.get("members_url"),
            "public_members_url": obj.get("public_members_url"),
            "avatar_url": obj.get("avatar_url"),
            "description": obj.get("description"),
            "name": obj.get("name"),
            "company": obj.get("company"),
            "blog": obj.get("blog"),
            "location": obj.get("location"),
            "email": obj.get("email"),
            "twitter_username": obj.get("twitter_username"),
            "is_verified": obj.get("is_verified"),
            "has_organization_projects": obj.get("has_organization_projects"),
            "has_repository_projects": obj.get("has_repository_projects"),
            "public_repos": obj.get("public_repos"),
            "public_gists": obj.get("public_gists"),
            "followers": obj.get("followers"),
            "following": obj.get("following"),
            "html_url": obj.get("html_url"),
            "created_at": obj.get("created_at"),
            "type": obj.get("type"),
            "total_private_repos": obj.get("total_private_repos"),
            "owned_private_repos": obj.get("owned_private_repos"),
            "private_gists": obj.get("private_gists"),
            "disk_usage": obj.get("disk_usage"),
            "collaborators": obj.get("collaborators"),
            "billing_email": obj.get("billing_email"),
            "plan": OrganizationFullPlan.from_dict(obj["plan"]) if obj.get("plan") is not None else None,
            "default_repository_permission": obj.get("default_repository_permission"),
            "members_can_create_repositories": obj.get("members_can_create_repositories"),
            "two_factor_requirement_enabled": obj.get("two_factor_requirement_enabled"),
            "members_allowed_repository_creation_type": obj.get("members_allowed_repository_creation_type"),
            "members_can_create_public_repositories": obj.get("members_can_create_public_repositories"),
            "members_can_create_private_repositories": obj.get("members_can_create_private_repositories"),
            "members_can_create_internal_repositories": obj.get("members_can_create_internal_repositories"),
            "members_can_create_pages": obj.get("members_can_create_pages"),
            "members_can_create_public_pages": obj.get("members_can_create_public_pages"),
            "members_can_create_private_pages": obj.get("members_can_create_private_pages"),
            "members_can_fork_private_repositories": obj.get("members_can_fork_private_repositories"),
            "web_commit_signoff_required": obj.get("web_commit_signoff_required"),
            "updated_at": obj.get("updated_at"),
            "archived_at": obj.get("archived_at")
        })
        return _obj


