# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class TeamSimple(BaseModel):
    """
    Groups of organization members that gives permissions on specified repositories.
    """ # noqa: E501
    id: StrictInt = Field(description="Unique identifier of the team")
    node_id: StrictStr
    url: StrictStr = Field(description="URL for the team")
    members_url: StrictStr
    name: StrictStr = Field(description="Name of the team")
    description: Optional[StrictStr] = Field(description="Description of the team")
    permission: StrictStr = Field(description="Permission that the team will have for its repositories")
    privacy: Optional[StrictStr] = Field(default=None, description="The level of privacy this team should have")
    notification_setting: Optional[StrictStr] = Field(default=None, description="The notification setting the team has set")
    html_url: StrictStr
    repositories_url: StrictStr
    slug: StrictStr
    ldap_dn: Optional[StrictStr] = Field(default=None, description="Distinguished Name (DN) that team maps to within LDAP environment")
    type: StrictStr = Field(description="The ownership type of the team")
    organization_id: Optional[StrictInt] = Field(default=None, description="Unique identifier of the organization to which this team belongs")
    enterprise_id: Optional[StrictInt] = Field(default=None, description="Unique identifier of the enterprise to which this team belongs")
    __properties: ClassVar[List[str]] = ["id", "node_id", "url", "members_url", "name", "description", "permission", "privacy", "notification_setting", "html_url", "repositories_url", "slug", "ldap_dn", "type", "organization_id", "enterprise_id"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['enterprise', 'organization']):
            raise ValueError("must be one of enum values ('enterprise', 'organization')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TeamSimple from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TeamSimple from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "url": obj.get("url"),
            "members_url": obj.get("members_url"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "permission": obj.get("permission"),
            "privacy": obj.get("privacy"),
            "notification_setting": obj.get("notification_setting"),
            "html_url": obj.get("html_url"),
            "repositories_url": obj.get("repositories_url"),
            "slug": obj.get("slug"),
            "ldap_dn": obj.get("ldap_dn"),
            "type": obj.get("type"),
            "organization_id": obj.get("organization_id"),
            "enterprise_id": obj.get("enterprise_id")
        })
        return _obj


