# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.author_association import AuthorAssociation
from devopso.clients.github.models.nullable_integration import NullableIntegration
from devopso.clients.github.models.reaction_rollup import ReactionRollup
from devopso.clients.github.models.simple_user import SimpleUser
from typing import Optional, Set
from typing_extensions import Self

class TimelineCommentEvent(BaseModel):
    """
    Timeline Comment Event
    """ # noqa: E501
    event: StrictStr
    actor: SimpleUser
    id: StrictInt = Field(description="Unique identifier of the issue comment")
    node_id: StrictStr
    url: StrictStr = Field(description="URL for the issue comment")
    body: Optional[StrictStr] = Field(default=None, description="Contents of the issue comment")
    body_text: Optional[StrictStr] = None
    body_html: Optional[StrictStr] = None
    html_url: StrictStr
    user: SimpleUser
    created_at: datetime
    updated_at: datetime
    issue_url: StrictStr
    author_association: AuthorAssociation
    performed_via_github_app: Optional[NullableIntegration] = None
    reactions: Optional[ReactionRollup] = None
    __properties: ClassVar[List[str]] = ["event", "actor", "id", "node_id", "url", "body", "body_text", "body_html", "html_url", "user", "created_at", "updated_at", "issue_url", "author_association", "performed_via_github_app", "reactions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TimelineCommentEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of actor
        if self.actor:
            _dict['actor'] = self.actor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of performed_via_github_app
        if self.performed_via_github_app:
            _dict['performed_via_github_app'] = self.performed_via_github_app.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reactions
        if self.reactions:
            _dict['reactions'] = self.reactions.to_dict()
        # set to None if performed_via_github_app (nullable) is None
        # and model_fields_set contains the field
        if self.performed_via_github_app is None and "performed_via_github_app" in self.model_fields_set:
            _dict['performed_via_github_app'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TimelineCommentEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "event": obj.get("event"),
            "actor": SimpleUser.from_dict(obj["actor"]) if obj.get("actor") is not None else None,
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "url": obj.get("url"),
            "body": obj.get("body"),
            "body_text": obj.get("body_text"),
            "body_html": obj.get("body_html"),
            "html_url": obj.get("html_url"),
            "user": SimpleUser.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "issue_url": obj.get("issue_url"),
            "author_association": obj.get("author_association"),
            "performed_via_github_app": NullableIntegration.from_dict(obj["performed_via_github_app"]) if obj.get("performed_via_github_app") is not None else None,
            "reactions": ReactionRollup.from_dict(obj["reactions"]) if obj.get("reactions") is not None else None
        })
        return _obj


