# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from devopso.clients.github.models.search_result_text_matches_inner import SearchResultTextMatchesInner
from devopso.clients.github.models.topic_search_result_item_related_inner import TopicSearchResultItemRelatedInner
from typing import Optional, Set
from typing_extensions import Self

class TopicSearchResultItem(BaseModel):
    """
    Topic Search Result Item
    """ # noqa: E501
    name: StrictStr
    display_name: Optional[StrictStr]
    short_description: Optional[StrictStr]
    description: Optional[StrictStr]
    created_by: Optional[StrictStr]
    released: Optional[StrictStr]
    created_at: datetime
    updated_at: datetime
    featured: StrictBool
    curated: StrictBool
    score: Union[StrictFloat, StrictInt]
    repository_count: Optional[StrictInt] = None
    logo_url: Optional[StrictStr] = None
    text_matches: Optional[List[SearchResultTextMatchesInner]] = None
    related: Optional[List[TopicSearchResultItemRelatedInner]] = None
    aliases: Optional[List[TopicSearchResultItemRelatedInner]] = None
    __properties: ClassVar[List[str]] = ["name", "display_name", "short_description", "description", "created_by", "released", "created_at", "updated_at", "featured", "curated", "score", "repository_count", "logo_url", "text_matches", "related", "aliases"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TopicSearchResultItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in text_matches (list)
        _items = []
        if self.text_matches:
            for _item_text_matches in self.text_matches:
                if _item_text_matches:
                    _items.append(_item_text_matches.to_dict())
            _dict['text_matches'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in related (list)
        _items = []
        if self.related:
            for _item_related in self.related:
                if _item_related:
                    _items.append(_item_related.to_dict())
            _dict['related'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in aliases (list)
        _items = []
        if self.aliases:
            for _item_aliases in self.aliases:
                if _item_aliases:
                    _items.append(_item_aliases.to_dict())
            _dict['aliases'] = _items
        # set to None if display_name (nullable) is None
        # and model_fields_set contains the field
        if self.display_name is None and "display_name" in self.model_fields_set:
            _dict['display_name'] = None

        # set to None if short_description (nullable) is None
        # and model_fields_set contains the field
        if self.short_description is None and "short_description" in self.model_fields_set:
            _dict['short_description'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if created_by (nullable) is None
        # and model_fields_set contains the field
        if self.created_by is None and "created_by" in self.model_fields_set:
            _dict['created_by'] = None

        # set to None if released (nullable) is None
        # and model_fields_set contains the field
        if self.released is None and "released" in self.model_fields_set:
            _dict['released'] = None

        # set to None if repository_count (nullable) is None
        # and model_fields_set contains the field
        if self.repository_count is None and "repository_count" in self.model_fields_set:
            _dict['repository_count'] = None

        # set to None if logo_url (nullable) is None
        # and model_fields_set contains the field
        if self.logo_url is None and "logo_url" in self.model_fields_set:
            _dict['logo_url'] = None

        # set to None if related (nullable) is None
        # and model_fields_set contains the field
        if self.related is None and "related" in self.model_fields_set:
            _dict['related'] = None

        # set to None if aliases (nullable) is None
        # and model_fields_set contains the field
        if self.aliases is None and "aliases" in self.model_fields_set:
            _dict['aliases'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TopicSearchResultItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "display_name": obj.get("display_name"),
            "short_description": obj.get("short_description"),
            "description": obj.get("description"),
            "created_by": obj.get("created_by"),
            "released": obj.get("released"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "featured": obj.get("featured"),
            "curated": obj.get("curated"),
            "score": obj.get("score"),
            "repository_count": obj.get("repository_count"),
            "logo_url": obj.get("logo_url"),
            "text_matches": [SearchResultTextMatchesInner.from_dict(_item) for _item in obj["text_matches"]] if obj.get("text_matches") is not None else None,
            "related": [TopicSearchResultItemRelatedInner.from_dict(_item) for _item in obj["related"]] if obj.get("related") is not None else None,
            "aliases": [TopicSearchResultItemRelatedInner.from_dict(_item) for _item in obj["aliases"]] if obj.get("aliases") is not None else None
        })
        return _obj


