# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from devopso.clients.github.models.search_result_text_matches_inner import SearchResultTextMatchesInner
from typing import Optional, Set
from typing_extensions import Self

class UserSearchResultItem(BaseModel):
    """
    User Search Result Item
    """ # noqa: E501
    login: StrictStr
    id: StrictInt
    node_id: StrictStr
    avatar_url: StrictStr
    gravatar_id: Optional[StrictStr]
    url: StrictStr
    html_url: StrictStr
    followers_url: StrictStr
    subscriptions_url: StrictStr
    organizations_url: StrictStr
    repos_url: StrictStr
    received_events_url: StrictStr
    type: StrictStr
    score: Union[StrictFloat, StrictInt]
    following_url: StrictStr
    gists_url: StrictStr
    starred_url: StrictStr
    events_url: StrictStr
    public_repos: Optional[StrictInt] = None
    public_gists: Optional[StrictInt] = None
    followers: Optional[StrictInt] = None
    following: Optional[StrictInt] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    name: Optional[StrictStr] = None
    bio: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    location: Optional[StrictStr] = None
    site_admin: StrictBool
    hireable: Optional[StrictBool] = None
    text_matches: Optional[List[SearchResultTextMatchesInner]] = None
    blog: Optional[StrictStr] = None
    company: Optional[StrictStr] = None
    suspended_at: Optional[datetime] = None
    user_view_type: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["login", "id", "node_id", "avatar_url", "gravatar_id", "url", "html_url", "followers_url", "subscriptions_url", "organizations_url", "repos_url", "received_events_url", "type", "score", "following_url", "gists_url", "starred_url", "events_url", "public_repos", "public_gists", "followers", "following", "created_at", "updated_at", "name", "bio", "email", "location", "site_admin", "hireable", "text_matches", "blog", "company", "suspended_at", "user_view_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserSearchResultItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in text_matches (list)
        _items = []
        if self.text_matches:
            for _item_text_matches in self.text_matches:
                if _item_text_matches:
                    _items.append(_item_text_matches.to_dict())
            _dict['text_matches'] = _items
        # set to None if gravatar_id (nullable) is None
        # and model_fields_set contains the field
        if self.gravatar_id is None and "gravatar_id" in self.model_fields_set:
            _dict['gravatar_id'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if bio (nullable) is None
        # and model_fields_set contains the field
        if self.bio is None and "bio" in self.model_fields_set:
            _dict['bio'] = None

        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if location (nullable) is None
        # and model_fields_set contains the field
        if self.location is None and "location" in self.model_fields_set:
            _dict['location'] = None

        # set to None if hireable (nullable) is None
        # and model_fields_set contains the field
        if self.hireable is None and "hireable" in self.model_fields_set:
            _dict['hireable'] = None

        # set to None if blog (nullable) is None
        # and model_fields_set contains the field
        if self.blog is None and "blog" in self.model_fields_set:
            _dict['blog'] = None

        # set to None if company (nullable) is None
        # and model_fields_set contains the field
        if self.company is None and "company" in self.model_fields_set:
            _dict['company'] = None

        # set to None if suspended_at (nullable) is None
        # and model_fields_set contains the field
        if self.suspended_at is None and "suspended_at" in self.model_fields_set:
            _dict['suspended_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserSearchResultItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "login": obj.get("login"),
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "avatar_url": obj.get("avatar_url"),
            "gravatar_id": obj.get("gravatar_id"),
            "url": obj.get("url"),
            "html_url": obj.get("html_url"),
            "followers_url": obj.get("followers_url"),
            "subscriptions_url": obj.get("subscriptions_url"),
            "organizations_url": obj.get("organizations_url"),
            "repos_url": obj.get("repos_url"),
            "received_events_url": obj.get("received_events_url"),
            "type": obj.get("type"),
            "score": obj.get("score"),
            "following_url": obj.get("following_url"),
            "gists_url": obj.get("gists_url"),
            "starred_url": obj.get("starred_url"),
            "events_url": obj.get("events_url"),
            "public_repos": obj.get("public_repos"),
            "public_gists": obj.get("public_gists"),
            "followers": obj.get("followers"),
            "following": obj.get("following"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "name": obj.get("name"),
            "bio": obj.get("bio"),
            "email": obj.get("email"),
            "location": obj.get("location"),
            "site_admin": obj.get("site_admin"),
            "hireable": obj.get("hireable"),
            "text_matches": [SearchResultTextMatchesInner.from_dict(_item) for _item in obj["text_matches"]] if obj.get("text_matches") is not None else None,
            "blog": obj.get("blog"),
            "company": obj.get("company"),
            "suspended_at": obj.get("suspended_at"),
            "user_view_type": obj.get("user_view_type")
        })
        return _obj


