# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.hook_response import HookResponse
from devopso.clients.github.models.webhook_config import WebhookConfig
from typing import Optional, Set
from typing_extensions import Self

class Webhook(BaseModel):
    """
    The webhook that is being pinged
    """ # noqa: E501
    active: StrictBool = Field(description="Determines whether the hook is actually triggered for the events it subscribes to.")
    app_id: Optional[StrictInt] = Field(default=None, description="Only included for GitHub Apps. When you register a new GitHub App, GitHub sends a ping event to the webhook URL you specified during registration. The GitHub App ID sent in this field is required for authenticating an app.")
    config: WebhookConfig
    created_at: datetime
    deliveries_url: Optional[StrictStr] = None
    events: List[StrictStr] = Field(description="Determines what events the hook is triggered for. Default: ['push'].")
    id: StrictInt = Field(description="Unique identifier of the webhook.")
    last_response: Optional[HookResponse] = None
    name: StrictStr = Field(description="The type of webhook. The only valid value is 'web'.")
    ping_url: Optional[StrictStr] = None
    test_url: Optional[StrictStr] = None
    type: StrictStr
    updated_at: datetime
    url: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["active", "app_id", "config", "created_at", "deliveries_url", "events", "id", "last_response", "name", "ping_url", "test_url", "type", "updated_at", "url"]

    @field_validator('name')
    def name_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['web']):
            raise ValueError("must be one of enum values ('web')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Webhook from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_response
        if self.last_response:
            _dict['last_response'] = self.last_response.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Webhook from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "active": obj.get("active"),
            "app_id": obj.get("app_id"),
            "config": WebhookConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "created_at": obj.get("created_at"),
            "deliveries_url": obj.get("deliveries_url"),
            "events": obj.get("events"),
            "id": obj.get("id"),
            "last_response": HookResponse.from_dict(obj["last_response"]) if obj.get("last_response") is not None else None,
            "name": obj.get("name"),
            "ping_url": obj.get("ping_url"),
            "test_url": obj.get("test_url"),
            "type": obj.get("type"),
            "updated_at": obj.get("updated_at"),
            "url": obj.get("url")
        })
        return _obj


