# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.webhook_branch_protection_rule_edited_changes_admin_enforced import WebhookBranchProtectionRuleEditedChangesAdminEnforced
from devopso.clients.github.models.webhook_branch_protection_rule_edited_changes_authorized_actor_names import WebhookBranchProtectionRuleEditedChangesAuthorizedActorNames
from devopso.clients.github.models.webhook_branch_protection_rule_edited_changes_linear_history_requirement_enforcement_level import WebhookBranchProtectionRuleEditedChangesLinearHistoryRequirementEnforcementLevel
from typing import Optional, Set
from typing_extensions import Self

class WebhookBranchProtectionRuleEditedChanges(BaseModel):
    """
    If the action was `edited`, the changes to the rule.
    """ # noqa: E501
    admin_enforced: Optional[WebhookBranchProtectionRuleEditedChangesAdminEnforced] = None
    authorized_actor_names: Optional[WebhookBranchProtectionRuleEditedChangesAuthorizedActorNames] = None
    authorized_actors_only: Optional[WebhookBranchProtectionRuleEditedChangesAdminEnforced] = None
    authorized_dismissal_actors_only: Optional[WebhookBranchProtectionRuleEditedChangesAdminEnforced] = None
    linear_history_requirement_enforcement_level: Optional[WebhookBranchProtectionRuleEditedChangesLinearHistoryRequirementEnforcementLevel] = None
    lock_branch_enforcement_level: Optional[WebhookBranchProtectionRuleEditedChangesLinearHistoryRequirementEnforcementLevel] = None
    lock_allows_fork_sync: Optional[WebhookBranchProtectionRuleEditedChangesAdminEnforced] = None
    pull_request_reviews_enforcement_level: Optional[WebhookBranchProtectionRuleEditedChangesLinearHistoryRequirementEnforcementLevel] = None
    require_last_push_approval: Optional[WebhookBranchProtectionRuleEditedChangesAdminEnforced] = None
    required_status_checks: Optional[WebhookBranchProtectionRuleEditedChangesAuthorizedActorNames] = None
    required_status_checks_enforcement_level: Optional[WebhookBranchProtectionRuleEditedChangesLinearHistoryRequirementEnforcementLevel] = None
    __properties: ClassVar[List[str]] = ["admin_enforced", "authorized_actor_names", "authorized_actors_only", "authorized_dismissal_actors_only", "linear_history_requirement_enforcement_level", "lock_branch_enforcement_level", "lock_allows_fork_sync", "pull_request_reviews_enforcement_level", "require_last_push_approval", "required_status_checks", "required_status_checks_enforcement_level"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookBranchProtectionRuleEditedChanges from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of admin_enforced
        if self.admin_enforced:
            _dict['admin_enforced'] = self.admin_enforced.to_dict()
        # override the default output from pydantic by calling `to_dict()` of authorized_actor_names
        if self.authorized_actor_names:
            _dict['authorized_actor_names'] = self.authorized_actor_names.to_dict()
        # override the default output from pydantic by calling `to_dict()` of authorized_actors_only
        if self.authorized_actors_only:
            _dict['authorized_actors_only'] = self.authorized_actors_only.to_dict()
        # override the default output from pydantic by calling `to_dict()` of authorized_dismissal_actors_only
        if self.authorized_dismissal_actors_only:
            _dict['authorized_dismissal_actors_only'] = self.authorized_dismissal_actors_only.to_dict()
        # override the default output from pydantic by calling `to_dict()` of linear_history_requirement_enforcement_level
        if self.linear_history_requirement_enforcement_level:
            _dict['linear_history_requirement_enforcement_level'] = self.linear_history_requirement_enforcement_level.to_dict()
        # override the default output from pydantic by calling `to_dict()` of lock_branch_enforcement_level
        if self.lock_branch_enforcement_level:
            _dict['lock_branch_enforcement_level'] = self.lock_branch_enforcement_level.to_dict()
        # override the default output from pydantic by calling `to_dict()` of lock_allows_fork_sync
        if self.lock_allows_fork_sync:
            _dict['lock_allows_fork_sync'] = self.lock_allows_fork_sync.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pull_request_reviews_enforcement_level
        if self.pull_request_reviews_enforcement_level:
            _dict['pull_request_reviews_enforcement_level'] = self.pull_request_reviews_enforcement_level.to_dict()
        # override the default output from pydantic by calling `to_dict()` of require_last_push_approval
        if self.require_last_push_approval:
            _dict['require_last_push_approval'] = self.require_last_push_approval.to_dict()
        # override the default output from pydantic by calling `to_dict()` of required_status_checks
        if self.required_status_checks:
            _dict['required_status_checks'] = self.required_status_checks.to_dict()
        # override the default output from pydantic by calling `to_dict()` of required_status_checks_enforcement_level
        if self.required_status_checks_enforcement_level:
            _dict['required_status_checks_enforcement_level'] = self.required_status_checks_enforcement_level.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookBranchProtectionRuleEditedChanges from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "admin_enforced": WebhookBranchProtectionRuleEditedChangesAdminEnforced.from_dict(obj["admin_enforced"]) if obj.get("admin_enforced") is not None else None,
            "authorized_actor_names": WebhookBranchProtectionRuleEditedChangesAuthorizedActorNames.from_dict(obj["authorized_actor_names"]) if obj.get("authorized_actor_names") is not None else None,
            "authorized_actors_only": WebhookBranchProtectionRuleEditedChangesAdminEnforced.from_dict(obj["authorized_actors_only"]) if obj.get("authorized_actors_only") is not None else None,
            "authorized_dismissal_actors_only": WebhookBranchProtectionRuleEditedChangesAdminEnforced.from_dict(obj["authorized_dismissal_actors_only"]) if obj.get("authorized_dismissal_actors_only") is not None else None,
            "linear_history_requirement_enforcement_level": WebhookBranchProtectionRuleEditedChangesLinearHistoryRequirementEnforcementLevel.from_dict(obj["linear_history_requirement_enforcement_level"]) if obj.get("linear_history_requirement_enforcement_level") is not None else None,
            "lock_branch_enforcement_level": WebhookBranchProtectionRuleEditedChangesLinearHistoryRequirementEnforcementLevel.from_dict(obj["lock_branch_enforcement_level"]) if obj.get("lock_branch_enforcement_level") is not None else None,
            "lock_allows_fork_sync": WebhookBranchProtectionRuleEditedChangesAdminEnforced.from_dict(obj["lock_allows_fork_sync"]) if obj.get("lock_allows_fork_sync") is not None else None,
            "pull_request_reviews_enforcement_level": WebhookBranchProtectionRuleEditedChangesLinearHistoryRequirementEnforcementLevel.from_dict(obj["pull_request_reviews_enforcement_level"]) if obj.get("pull_request_reviews_enforcement_level") is not None else None,
            "require_last_push_approval": WebhookBranchProtectionRuleEditedChangesAdminEnforced.from_dict(obj["require_last_push_approval"]) if obj.get("require_last_push_approval") is not None else None,
            "required_status_checks": WebhookBranchProtectionRuleEditedChangesAuthorizedActorNames.from_dict(obj["required_status_checks"]) if obj.get("required_status_checks") is not None else None,
            "required_status_checks_enforcement_level": WebhookBranchProtectionRuleEditedChangesLinearHistoryRequirementEnforcementLevel.from_dict(obj["required_status_checks_enforcement_level"]) if obj.get("required_status_checks_enforcement_level") is not None else None
        })
        return _obj


