# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.app3 import App3
from devopso.clients.github.models.check_run_pull_request import CheckRunPullRequest
from devopso.clients.github.models.simple_commit import SimpleCommit
from typing import Optional, Set
from typing_extensions import Self

class WebhookCheckSuiteRequestedCheckSuite(BaseModel):
    """
    The [check_suite](https://docs.github.com/rest/checks/suites#get-a-check-suite).
    """ # noqa: E501
    after: Optional[StrictStr]
    app: App3
    before: Optional[StrictStr]
    check_runs_url: StrictStr
    conclusion: Optional[StrictStr] = Field(description="The summary conclusion for all check runs that are part of the check suite. This value will be `null` until the check run has completed.")
    created_at: datetime
    head_branch: Optional[StrictStr] = Field(description="The head branch name the changes are on.")
    head_commit: SimpleCommit
    head_sha: StrictStr = Field(description="The SHA of the head commit that is being checked.")
    id: StrictInt
    latest_check_runs_count: StrictInt
    node_id: StrictStr
    pull_requests: List[CheckRunPullRequest] = Field(description="An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.")
    rerequestable: Optional[StrictBool] = None
    runs_rerequestable: Optional[StrictBool] = None
    status: Optional[StrictStr] = Field(description="The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`.")
    updated_at: datetime
    url: StrictStr = Field(description="URL that points to the check suite API resource.")
    __properties: ClassVar[List[str]] = ["after", "app", "before", "check_runs_url", "conclusion", "created_at", "head_branch", "head_commit", "head_sha", "id", "latest_check_runs_count", "node_id", "pull_requests", "rerequestable", "runs_rerequestable", "status", "updated_at", "url"]

    @field_validator('conclusion')
    def conclusion_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['success', 'failure', 'neutral', 'cancelled', 'timed_out', 'action_required', 'stale', 'skipped']):
            raise ValueError("must be one of enum values ('success', 'failure', 'neutral', 'cancelled', 'timed_out', 'action_required', 'stale', 'skipped')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['requested', 'in_progress', 'completed', 'queued']):
            raise ValueError("must be one of enum values ('requested', 'in_progress', 'completed', 'queued')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookCheckSuiteRequestedCheckSuite from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of app
        if self.app:
            _dict['app'] = self.app.to_dict()
        # override the default output from pydantic by calling `to_dict()` of head_commit
        if self.head_commit:
            _dict['head_commit'] = self.head_commit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in pull_requests (list)
        _items = []
        if self.pull_requests:
            for _item_pull_requests in self.pull_requests:
                if _item_pull_requests:
                    _items.append(_item_pull_requests.to_dict())
            _dict['pull_requests'] = _items
        # set to None if after (nullable) is None
        # and model_fields_set contains the field
        if self.after is None and "after" in self.model_fields_set:
            _dict['after'] = None

        # set to None if before (nullable) is None
        # and model_fields_set contains the field
        if self.before is None and "before" in self.model_fields_set:
            _dict['before'] = None

        # set to None if conclusion (nullable) is None
        # and model_fields_set contains the field
        if self.conclusion is None and "conclusion" in self.model_fields_set:
            _dict['conclusion'] = None

        # set to None if head_branch (nullable) is None
        # and model_fields_set contains the field
        if self.head_branch is None and "head_branch" in self.model_fields_set:
            _dict['head_branch'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookCheckSuiteRequestedCheckSuite from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "after": obj.get("after"),
            "app": App3.from_dict(obj["app"]) if obj.get("app") is not None else None,
            "before": obj.get("before"),
            "check_runs_url": obj.get("check_runs_url"),
            "conclusion": obj.get("conclusion"),
            "created_at": obj.get("created_at"),
            "head_branch": obj.get("head_branch"),
            "head_commit": SimpleCommit.from_dict(obj["head_commit"]) if obj.get("head_commit") is not None else None,
            "head_sha": obj.get("head_sha"),
            "id": obj.get("id"),
            "latest_check_runs_count": obj.get("latest_check_runs_count"),
            "node_id": obj.get("node_id"),
            "pull_requests": [CheckRunPullRequest.from_dict(_item) for _item in obj["pull_requests"]] if obj.get("pull_requests") is not None else None,
            "rerequestable": obj.get("rerequestable"),
            "runs_rerequestable": obj.get("runs_rerequestable"),
            "status": obj.get("status"),
            "updated_at": obj.get("updated_at"),
            "url": obj.get("url")
        })
        return _obj


