# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.deployment_workflow_run1 import DeploymentWorkflowRun1
from devopso.clients.github.models.enterprise_webhooks import EnterpriseWebhooks
from devopso.clients.github.models.organization_simple_webhooks import OrganizationSimpleWebhooks
from devopso.clients.github.models.repository_webhooks import RepositoryWebhooks
from devopso.clients.github.models.simple_installation import SimpleInstallation
from devopso.clients.github.models.simple_user import SimpleUser
from devopso.clients.github.models.webhook_deployment_review_approved_workflow_job_runs_inner import WebhookDeploymentReviewApprovedWorkflowJobRunsInner
from devopso.clients.github.models.webhooks_approver import WebhooksApprover
from devopso.clients.github.models.webhooks_reviewers_inner import WebhooksReviewersInner
from devopso.clients.github.models.webhooks_workflow_job_run import WebhooksWorkflowJobRun
from typing import Optional, Set
from typing_extensions import Self

class WebhookDeploymentReviewApproved(BaseModel):
    """
    WebhookDeploymentReviewApproved
    """ # noqa: E501
    action: StrictStr
    approver: Optional[WebhooksApprover] = None
    comment: Optional[StrictStr] = None
    enterprise: Optional[EnterpriseWebhooks] = None
    installation: Optional[SimpleInstallation] = None
    organization: OrganizationSimpleWebhooks
    repository: RepositoryWebhooks
    reviewers: Optional[List[WebhooksReviewersInner]] = None
    sender: SimpleUser
    since: StrictStr
    workflow_job_run: Optional[WebhooksWorkflowJobRun] = None
    workflow_job_runs: Optional[List[WebhookDeploymentReviewApprovedWorkflowJobRunsInner]] = None
    workflow_run: Optional[DeploymentWorkflowRun1]
    __properties: ClassVar[List[str]] = ["action", "approver", "comment", "enterprise", "installation", "organization", "repository", "reviewers", "sender", "since", "workflow_job_run", "workflow_job_runs", "workflow_run"]

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['approved']):
            raise ValueError("must be one of enum values ('approved')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookDeploymentReviewApproved from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of approver
        if self.approver:
            _dict['approver'] = self.approver.to_dict()
        # override the default output from pydantic by calling `to_dict()` of enterprise
        if self.enterprise:
            _dict['enterprise'] = self.enterprise.to_dict()
        # override the default output from pydantic by calling `to_dict()` of installation
        if self.installation:
            _dict['installation'] = self.installation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict['organization'] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of repository
        if self.repository:
            _dict['repository'] = self.repository.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in reviewers (list)
        _items = []
        if self.reviewers:
            for _item_reviewers in self.reviewers:
                if _item_reviewers:
                    _items.append(_item_reviewers.to_dict())
            _dict['reviewers'] = _items
        # override the default output from pydantic by calling `to_dict()` of sender
        if self.sender:
            _dict['sender'] = self.sender.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workflow_job_run
        if self.workflow_job_run:
            _dict['workflow_job_run'] = self.workflow_job_run.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in workflow_job_runs (list)
        _items = []
        if self.workflow_job_runs:
            for _item_workflow_job_runs in self.workflow_job_runs:
                if _item_workflow_job_runs:
                    _items.append(_item_workflow_job_runs.to_dict())
            _dict['workflow_job_runs'] = _items
        # override the default output from pydantic by calling `to_dict()` of workflow_run
        if self.workflow_run:
            _dict['workflow_run'] = self.workflow_run.to_dict()
        # set to None if workflow_run (nullable) is None
        # and model_fields_set contains the field
        if self.workflow_run is None and "workflow_run" in self.model_fields_set:
            _dict['workflow_run'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookDeploymentReviewApproved from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "action": obj.get("action"),
            "approver": WebhooksApprover.from_dict(obj["approver"]) if obj.get("approver") is not None else None,
            "comment": obj.get("comment"),
            "enterprise": EnterpriseWebhooks.from_dict(obj["enterprise"]) if obj.get("enterprise") is not None else None,
            "installation": SimpleInstallation.from_dict(obj["installation"]) if obj.get("installation") is not None else None,
            "organization": OrganizationSimpleWebhooks.from_dict(obj["organization"]) if obj.get("organization") is not None else None,
            "repository": RepositoryWebhooks.from_dict(obj["repository"]) if obj.get("repository") is not None else None,
            "reviewers": [WebhooksReviewersInner.from_dict(_item) for _item in obj["reviewers"]] if obj.get("reviewers") is not None else None,
            "sender": SimpleUser.from_dict(obj["sender"]) if obj.get("sender") is not None else None,
            "since": obj.get("since"),
            "workflow_job_run": WebhooksWorkflowJobRun.from_dict(obj["workflow_job_run"]) if obj.get("workflow_job_run") is not None else None,
            "workflow_job_runs": [WebhookDeploymentReviewApprovedWorkflowJobRunsInner.from_dict(_item) for _item in obj["workflow_job_runs"]] if obj.get("workflow_job_runs") is not None else None,
            "workflow_run": DeploymentWorkflowRun1.from_dict(obj["workflow_run"]) if obj.get("workflow_run") is not None else None
        })
        return _obj


