# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.deployment1 import Deployment1
from devopso.clients.github.models.deployment_workflow_run4 import DeploymentWorkflowRun4
from devopso.clients.github.models.enterprise_webhooks import EnterpriseWebhooks
from devopso.clients.github.models.organization_simple_webhooks import OrganizationSimpleWebhooks
from devopso.clients.github.models.repository_webhooks import RepositoryWebhooks
from devopso.clients.github.models.simple_installation import SimpleInstallation
from devopso.clients.github.models.simple_user import SimpleUser
from devopso.clients.github.models.webhook_deployment_status_created_check_run import WebhookDeploymentStatusCreatedCheckRun
from devopso.clients.github.models.webhook_deployment_status_created_deployment_status import WebhookDeploymentStatusCreatedDeploymentStatus
from devopso.clients.github.models.webhooks_workflow import WebhooksWorkflow
from typing import Optional, Set
from typing_extensions import Self

class WebhookDeploymentStatusCreated(BaseModel):
    """
    WebhookDeploymentStatusCreated
    """ # noqa: E501
    action: StrictStr
    check_run: Optional[WebhookDeploymentStatusCreatedCheckRun] = None
    deployment: Deployment1
    deployment_status: WebhookDeploymentStatusCreatedDeploymentStatus
    enterprise: Optional[EnterpriseWebhooks] = None
    installation: Optional[SimpleInstallation] = None
    organization: Optional[OrganizationSimpleWebhooks] = None
    repository: RepositoryWebhooks
    sender: SimpleUser
    workflow: Optional[WebhooksWorkflow] = None
    workflow_run: Optional[DeploymentWorkflowRun4] = None
    __properties: ClassVar[List[str]] = ["action", "check_run", "deployment", "deployment_status", "enterprise", "installation", "organization", "repository", "sender", "workflow", "workflow_run"]

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['created']):
            raise ValueError("must be one of enum values ('created')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookDeploymentStatusCreated from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of check_run
        if self.check_run:
            _dict['check_run'] = self.check_run.to_dict()
        # override the default output from pydantic by calling `to_dict()` of deployment
        if self.deployment:
            _dict['deployment'] = self.deployment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of deployment_status
        if self.deployment_status:
            _dict['deployment_status'] = self.deployment_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of enterprise
        if self.enterprise:
            _dict['enterprise'] = self.enterprise.to_dict()
        # override the default output from pydantic by calling `to_dict()` of installation
        if self.installation:
            _dict['installation'] = self.installation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict['organization'] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of repository
        if self.repository:
            _dict['repository'] = self.repository.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sender
        if self.sender:
            _dict['sender'] = self.sender.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workflow
        if self.workflow:
            _dict['workflow'] = self.workflow.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workflow_run
        if self.workflow_run:
            _dict['workflow_run'] = self.workflow_run.to_dict()
        # set to None if check_run (nullable) is None
        # and model_fields_set contains the field
        if self.check_run is None and "check_run" in self.model_fields_set:
            _dict['check_run'] = None

        # set to None if workflow (nullable) is None
        # and model_fields_set contains the field
        if self.workflow is None and "workflow" in self.model_fields_set:
            _dict['workflow'] = None

        # set to None if workflow_run (nullable) is None
        # and model_fields_set contains the field
        if self.workflow_run is None and "workflow_run" in self.model_fields_set:
            _dict['workflow_run'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookDeploymentStatusCreated from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "action": obj.get("action"),
            "check_run": WebhookDeploymentStatusCreatedCheckRun.from_dict(obj["check_run"]) if obj.get("check_run") is not None else None,
            "deployment": Deployment1.from_dict(obj["deployment"]) if obj.get("deployment") is not None else None,
            "deployment_status": WebhookDeploymentStatusCreatedDeploymentStatus.from_dict(obj["deployment_status"]) if obj.get("deployment_status") is not None else None,
            "enterprise": EnterpriseWebhooks.from_dict(obj["enterprise"]) if obj.get("enterprise") is not None else None,
            "installation": SimpleInstallation.from_dict(obj["installation"]) if obj.get("installation") is not None else None,
            "organization": OrganizationSimpleWebhooks.from_dict(obj["organization"]) if obj.get("organization") is not None else None,
            "repository": RepositoryWebhooks.from_dict(obj["repository"]) if obj.get("repository") is not None else None,
            "sender": SimpleUser.from_dict(obj["sender"]) if obj.get("sender") is not None else None,
            "workflow": WebhooksWorkflow.from_dict(obj["workflow"]) if obj.get("workflow") is not None else None,
            "workflow_run": DeploymentWorkflowRun4.from_dict(obj["workflow_run"]) if obj.get("workflow_run") is not None else None
        })
        return _obj


