# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class WebhookDeploymentStatusCreatedCheckRun(BaseModel):
    """
    WebhookDeploymentStatusCreatedCheckRun
    """ # noqa: E501
    completed_at: Optional[datetime]
    conclusion: Optional[StrictStr] = Field(description="The result of the completed check run. This value will be `null` until the check run has completed.")
    details_url: StrictStr
    external_id: StrictStr
    head_sha: StrictStr = Field(description="The SHA of the commit that is being checked.")
    html_url: StrictStr
    id: StrictInt = Field(description="The id of the check.")
    name: StrictStr = Field(description="The name of the check run.")
    node_id: StrictStr
    started_at: datetime
    status: StrictStr = Field(description="The current status of the check run. Can be `queued`, `in_progress`, or `completed`.")
    url: StrictStr
    __properties: ClassVar[List[str]] = ["completed_at", "conclusion", "details_url", "external_id", "head_sha", "html_url", "id", "name", "node_id", "started_at", "status", "url"]

    @field_validator('conclusion')
    def conclusion_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['success', 'failure', 'neutral', 'cancelled', 'timed_out', 'action_required', 'stale', 'skipped']):
            raise ValueError("must be one of enum values ('success', 'failure', 'neutral', 'cancelled', 'timed_out', 'action_required', 'stale', 'skipped')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['queued', 'in_progress', 'completed', 'waiting', 'pending']):
            raise ValueError("must be one of enum values ('queued', 'in_progress', 'completed', 'waiting', 'pending')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookDeploymentStatusCreatedCheckRun from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if completed_at (nullable) is None
        # and model_fields_set contains the field
        if self.completed_at is None and "completed_at" in self.model_fields_set:
            _dict['completed_at'] = None

        # set to None if conclusion (nullable) is None
        # and model_fields_set contains the field
        if self.conclusion is None and "conclusion" in self.model_fields_set:
            _dict['conclusion'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookDeploymentStatusCreatedCheckRun from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "completed_at": obj.get("completed_at"),
            "conclusion": obj.get("conclusion"),
            "details_url": obj.get("details_url"),
            "external_id": obj.get("external_id"),
            "head_sha": obj.get("head_sha"),
            "html_url": obj.get("html_url"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "node_id": obj.get("node_id"),
            "started_at": obj.get("started_at"),
            "status": obj.get("status"),
            "url": obj.get("url")
        })
        return _obj


