# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.issue6 import Issue6
from devopso.clients.github.models.repository1 import Repository1
from typing import Optional, Set
from typing_extensions import Self

class WebhookIssuesOpenedChanges(BaseModel):
    """
    WebhookIssuesOpenedChanges
    """ # noqa: E501
    old_issue: Optional[Issue6]
    old_repository: Repository1
    __properties: ClassVar[List[str]] = ["old_issue", "old_repository"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookIssuesOpenedChanges from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of old_issue
        if self.old_issue:
            _dict['old_issue'] = self.old_issue.to_dict()
        # override the default output from pydantic by calling `to_dict()` of old_repository
        if self.old_repository:
            _dict['old_repository'] = self.old_repository.to_dict()
        # set to None if old_issue (nullable) is None
        # and model_fields_set contains the field
        if self.old_issue is None and "old_issue" in self.model_fields_set:
            _dict['old_issue'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookIssuesOpenedChanges from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "old_issue": Issue6.from_dict(obj["old_issue"]) if obj.get("old_issue") is not None else None,
            "old_repository": Repository1.from_dict(obj["old_repository"]) if obj.get("old_repository") is not None else None
        })
        return _obj


