# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from devopso.clients.github.models.webhook_meta_deleted_hook_config import WebhookMetaDeletedHookConfig
from typing import Optional, Set
from typing_extensions import Self

class WebhookMetaDeletedHook(BaseModel):
    """
    The deleted webhook. This will contain different keys based on the type of webhook it is: repository, organization, business, app, or GitHub Marketplace.
    """ # noqa: E501
    active: StrictBool
    config: WebhookMetaDeletedHookConfig
    created_at: StrictStr
    events: List[Annotated[str, Field(strict=True)]]
    id: StrictInt
    name: StrictStr
    type: StrictStr
    updated_at: StrictStr
    __properties: ClassVar[List[str]] = ["active", "config", "created_at", "events", "id", "name", "type", "updated_at"]

    @field_validator('events')
    def events_validate_enum(cls, value):
        """Validates the enum"""
        for i in value:
            if i not in set(['*', 'branch_protection_rule', 'check_run', 'check_suite', 'code_scanning_alert', 'commit_comment', 'create', 'delete', 'deployment', 'deployment_status', 'deploy_key', 'discussion', 'discussion_comment', 'fork', 'gollum', 'issues', 'issue_comment', 'label', 'member', 'membership', 'meta', 'milestone', 'organization', 'org_block', 'package', 'page_build', 'project', 'project_card', 'project_column', 'public', 'pull_request', 'pull_request_review', 'pull_request_review_comment', 'pull_request_review_thread', 'push', 'registry_package', 'release', 'repository', 'repository_import', 'repository_vulnerability_alert', 'secret_scanning_alert', 'secret_scanning_alert_location', 'security_and_analysis', 'star', 'status', 'team', 'team_add', 'watch', 'workflow_job', 'workflow_run', 'repository_dispatch', 'projects_v2_item']):
                raise ValueError("each list item must be one of ('*', 'branch_protection_rule', 'check_run', 'check_suite', 'code_scanning_alert', 'commit_comment', 'create', 'delete', 'deployment', 'deployment_status', 'deploy_key', 'discussion', 'discussion_comment', 'fork', 'gollum', 'issues', 'issue_comment', 'label', 'member', 'membership', 'meta', 'milestone', 'organization', 'org_block', 'package', 'page_build', 'project', 'project_card', 'project_column', 'public', 'pull_request', 'pull_request_review', 'pull_request_review_comment', 'pull_request_review_thread', 'push', 'registry_package', 'release', 'repository', 'repository_import', 'repository_vulnerability_alert', 'secret_scanning_alert', 'secret_scanning_alert_location', 'security_and_analysis', 'star', 'status', 'team', 'team_add', 'watch', 'workflow_job', 'workflow_run', 'repository_dispatch', 'projects_v2_item')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookMetaDeletedHook from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookMetaDeletedHook from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "active": obj.get("active"),
            "config": WebhookMetaDeletedHookConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "created_at": obj.get("created_at"),
            "events": obj.get("events"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "type": obj.get("type"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


