# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.webhook_label_edited_changes_description import WebhookLabelEditedChangesDescription
from devopso.clients.github.models.webhook_milestone_edited_changes_due_on import WebhookMilestoneEditedChangesDueOn
from devopso.clients.github.models.webhook_milestone_edited_changes_title import WebhookMilestoneEditedChangesTitle
from typing import Optional, Set
from typing_extensions import Self

class WebhookMilestoneEditedChanges(BaseModel):
    """
    The changes to the milestone if the action was `edited`.
    """ # noqa: E501
    description: Optional[WebhookLabelEditedChangesDescription] = None
    due_on: Optional[WebhookMilestoneEditedChangesDueOn] = None
    title: Optional[WebhookMilestoneEditedChangesTitle] = None
    __properties: ClassVar[List[str]] = ["description", "due_on", "title"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookMilestoneEditedChanges from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of description
        if self.description:
            _dict['description'] = self.description.to_dict()
        # override the default output from pydantic by calling `to_dict()` of due_on
        if self.due_on:
            _dict['due_on'] = self.due_on.to_dict()
        # override the default output from pydantic by calling `to_dict()` of title
        if self.title:
            _dict['title'] = self.title.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookMilestoneEditedChanges from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": WebhookLabelEditedChangesDescription.from_dict(obj["description"]) if obj.get("description") is not None else None,
            "due_on": WebhookMilestoneEditedChangesDueOn.from_dict(obj["due_on"]) if obj.get("due_on") is not None else None,
            "title": WebhookMilestoneEditedChangesTitle.from_dict(obj["title"]) if obj.get("title") is not None else None
        })
        return _obj


