# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.webhook_member_edited_changes_permission import WebhookMemberEditedChangesPermission
from devopso.clients.github.models.webhook_projects_v2_status_update_edited_changes_start_date import WebhookProjectsV2StatusUpdateEditedChangesStartDate
from devopso.clients.github.models.webhook_projects_v2_status_update_edited_changes_status import WebhookProjectsV2StatusUpdateEditedChangesStatus
from typing import Optional, Set
from typing_extensions import Self

class WebhookProjectsV2StatusUpdateEditedChanges(BaseModel):
    """
    WebhookProjectsV2StatusUpdateEditedChanges
    """ # noqa: E501
    body: Optional[WebhookMemberEditedChangesPermission] = None
    status: Optional[WebhookProjectsV2StatusUpdateEditedChangesStatus] = None
    start_date: Optional[WebhookProjectsV2StatusUpdateEditedChangesStartDate] = None
    target_date: Optional[WebhookProjectsV2StatusUpdateEditedChangesStartDate] = None
    __properties: ClassVar[List[str]] = ["body", "status", "start_date", "target_date"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookProjectsV2StatusUpdateEditedChanges from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of body
        if self.body:
            _dict['body'] = self.body.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of start_date
        if self.start_date:
            _dict['start_date'] = self.start_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of target_date
        if self.target_date:
            _dict['target_date'] = self.target_date.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookProjectsV2StatusUpdateEditedChanges from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "body": WebhookMemberEditedChangesPermission.from_dict(obj["body"]) if obj.get("body") is not None else None,
            "status": WebhookProjectsV2StatusUpdateEditedChangesStatus.from_dict(obj["status"]) if obj.get("status") is not None else None,
            "start_date": WebhookProjectsV2StatusUpdateEditedChangesStartDate.from_dict(obj["start_date"]) if obj.get("start_date") is not None else None,
            "target_date": WebhookProjectsV2StatusUpdateEditedChangesStartDate.from_dict(obj["target_date"]) if obj.get("target_date") is not None else None
        })
        return _obj


