# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.webhook_milestone_edited_changes_title import WebhookMilestoneEditedChangesTitle
from devopso.clients.github.models.webhook_project_edited_changes_body import WebhookProjectEditedChangesBody
from devopso.clients.github.models.webhook_pull_request_edited_changes_base import WebhookPullRequestEditedChangesBase
from typing import Optional, Set
from typing_extensions import Self

class WebhookPullRequestEditedChanges(BaseModel):
    """
    The changes to the comment if the action was `edited`.
    """ # noqa: E501
    base: Optional[WebhookPullRequestEditedChangesBase] = None
    body: Optional[WebhookProjectEditedChangesBody] = None
    title: Optional[WebhookMilestoneEditedChangesTitle] = None
    __properties: ClassVar[List[str]] = ["base", "body", "title"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookPullRequestEditedChanges from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of base
        if self.base:
            _dict['base'] = self.base.to_dict()
        # override the default output from pydantic by calling `to_dict()` of body
        if self.body:
            _dict['body'] = self.body.to_dict()
        # override the default output from pydantic by calling `to_dict()` of title
        if self.title:
            _dict['title'] = self.title.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookPullRequestEditedChanges from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "base": WebhookPullRequestEditedChangesBase.from_dict(obj["base"]) if obj.get("base") is not None else None,
            "body": WebhookProjectEditedChangesBody.from_dict(obj["body"]) if obj.get("body") is not None else None,
            "title": WebhookMilestoneEditedChangesTitle.from_dict(obj["title"]) if obj.get("title") is not None else None
        })
        return _obj


