# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.repository7 import Repository7
from devopso.clients.github.models.user1 import User1
from typing import Optional, Set
from typing_extensions import Self

class WebhookPullRequestReviewCommentCreatedPullRequestHead(BaseModel):
    """
    WebhookPullRequestReviewCommentCreatedPullRequestHead
    """ # noqa: E501
    label: StrictStr
    ref: StrictStr
    repo: Optional[Repository7]
    sha: StrictStr
    user: Optional[User1]
    __properties: ClassVar[List[str]] = ["label", "ref", "repo", "sha", "user"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookPullRequestReviewCommentCreatedPullRequestHead from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of repo
        if self.repo:
            _dict['repo'] = self.repo.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # set to None if repo (nullable) is None
        # and model_fields_set contains the field
        if self.repo is None and "repo" in self.model_fields_set:
            _dict['repo'] = None

        # set to None if user (nullable) is None
        # and model_fields_set contains the field
        if self.user is None and "user" in self.model_fields_set:
            _dict['user'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookPullRequestReviewCommentCreatedPullRequestHead from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "label": obj.get("label"),
            "ref": obj.get("ref"),
            "repo": Repository7.from_dict(obj["repo"]) if obj.get("repo") is not None else None,
            "sha": obj.get("sha"),
            "user": User1.from_dict(obj["user"]) if obj.get("user") is not None else None
        })
        return _obj


