# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.commit import Commit
from devopso.clients.github.models.commit1 import Commit1
from devopso.clients.github.models.committer1 import Committer1
from devopso.clients.github.models.enterprise_webhooks import EnterpriseWebhooks
from devopso.clients.github.models.organization_simple_webhooks import OrganizationSimpleWebhooks
from devopso.clients.github.models.repository2 import Repository2
from devopso.clients.github.models.simple_installation import SimpleInstallation
from devopso.clients.github.models.simple_user import SimpleUser
from typing import Optional, Set
from typing_extensions import Self

class WebhookPush(BaseModel):
    """
    WebhookPush
    """ # noqa: E501
    after: StrictStr = Field(description="The SHA of the most recent commit on `ref` after the push.")
    base_ref: Optional[StrictStr]
    before: StrictStr = Field(description="The SHA of the most recent commit on `ref` before the push.")
    commits: List[Commit] = Field(description="An array of commit objects describing the pushed commits. (Pushed commits are all commits that are included in the `compare` between the `before` commit and the `after` commit.) The array includes a maximum of 2048 commits. If necessary, you can use the [Commits API](https://docs.github.com/rest/commits) to fetch additional commits.")
    compare: StrictStr = Field(description="URL that shows the changes in this `ref` update, from the `before` commit to the `after` commit. For a newly created `ref` that is directly based on the default branch, this is the comparison between the head of the default branch and the `after` commit. Otherwise, this shows all commits until the `after` commit.")
    created: StrictBool = Field(description="Whether this push created the `ref`.")
    deleted: StrictBool = Field(description="Whether this push deleted the `ref`.")
    enterprise: Optional[EnterpriseWebhooks] = None
    forced: StrictBool = Field(description="Whether this push was a force push of the `ref`.")
    head_commit: Optional[Commit1]
    installation: Optional[SimpleInstallation] = None
    organization: Optional[OrganizationSimpleWebhooks] = None
    pusher: Committer1
    ref: StrictStr = Field(description="The full git ref that was pushed. Example: `refs/heads/main` or `refs/tags/v3.14.1`.")
    repository: Repository2
    sender: Optional[SimpleUser] = None
    __properties: ClassVar[List[str]] = ["after", "base_ref", "before", "commits", "compare", "created", "deleted", "enterprise", "forced", "head_commit", "installation", "organization", "pusher", "ref", "repository", "sender"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookPush from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in commits (list)
        _items = []
        if self.commits:
            for _item_commits in self.commits:
                if _item_commits:
                    _items.append(_item_commits.to_dict())
            _dict['commits'] = _items
        # override the default output from pydantic by calling `to_dict()` of enterprise
        if self.enterprise:
            _dict['enterprise'] = self.enterprise.to_dict()
        # override the default output from pydantic by calling `to_dict()` of head_commit
        if self.head_commit:
            _dict['head_commit'] = self.head_commit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of installation
        if self.installation:
            _dict['installation'] = self.installation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict['organization'] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pusher
        if self.pusher:
            _dict['pusher'] = self.pusher.to_dict()
        # override the default output from pydantic by calling `to_dict()` of repository
        if self.repository:
            _dict['repository'] = self.repository.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sender
        if self.sender:
            _dict['sender'] = self.sender.to_dict()
        # set to None if base_ref (nullable) is None
        # and model_fields_set contains the field
        if self.base_ref is None and "base_ref" in self.model_fields_set:
            _dict['base_ref'] = None

        # set to None if head_commit (nullable) is None
        # and model_fields_set contains the field
        if self.head_commit is None and "head_commit" in self.model_fields_set:
            _dict['head_commit'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookPush from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "after": obj.get("after"),
            "base_ref": obj.get("base_ref"),
            "before": obj.get("before"),
            "commits": [Commit.from_dict(_item) for _item in obj["commits"]] if obj.get("commits") is not None else None,
            "compare": obj.get("compare"),
            "created": obj.get("created"),
            "deleted": obj.get("deleted"),
            "enterprise": EnterpriseWebhooks.from_dict(obj["enterprise"]) if obj.get("enterprise") is not None else None,
            "forced": obj.get("forced"),
            "head_commit": Commit1.from_dict(obj["head_commit"]) if obj.get("head_commit") is not None else None,
            "installation": SimpleInstallation.from_dict(obj["installation"]) if obj.get("installation") is not None else None,
            "organization": OrganizationSimpleWebhooks.from_dict(obj["organization"]) if obj.get("organization") is not None else None,
            "pusher": Committer1.from_dict(obj["pusher"]) if obj.get("pusher") is not None else None,
            "ref": obj.get("ref"),
            "repository": Repository2.from_dict(obj["repository"]) if obj.get("repository") is not None else None,
            "sender": SimpleUser.from_dict(obj["sender"]) if obj.get("sender") is not None else None
        })
        return _obj


