# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.webhook_package_published_package_package_version_body import WebhookPackagePublishedPackagePackageVersionBody
from devopso.clients.github.models.webhook_package_published_package_package_version_docker_metadata_inner import WebhookPackagePublishedPackagePackageVersionDockerMetadataInner
from devopso.clients.github.models.webhook_registry_package_published_registry_package_owner import WebhookRegistryPackagePublishedRegistryPackageOwner
from devopso.clients.github.models.webhook_registry_package_published_registry_package_package_version_container_metadata import WebhookRegistryPackagePublishedRegistryPackagePackageVersionContainerMetadata
from devopso.clients.github.models.webhook_registry_package_published_registry_package_package_version_npm_metadata import WebhookRegistryPackagePublishedRegistryPackagePackageVersionNpmMetadata
from devopso.clients.github.models.webhook_registry_package_published_registry_package_package_version_nuget_metadata_inner import WebhookRegistryPackagePublishedRegistryPackagePackageVersionNugetMetadataInner
from devopso.clients.github.models.webhook_registry_package_published_registry_package_package_version_package_files_inner import WebhookRegistryPackagePublishedRegistryPackagePackageVersionPackageFilesInner
from devopso.clients.github.models.webhook_registry_package_published_registry_package_package_version_release import WebhookRegistryPackagePublishedRegistryPackagePackageVersionRelease
from devopso.clients.github.models.webhook_rubygems_metadata import WebhookRubygemsMetadata
from typing import Optional, Set
from typing_extensions import Self

class WebhookRegistryPackagePublishedRegistryPackagePackageVersion(BaseModel):
    """
    WebhookRegistryPackagePublishedRegistryPackagePackageVersion
    """ # noqa: E501
    author: Optional[WebhookRegistryPackagePublishedRegistryPackageOwner] = None
    body: Optional[WebhookPackagePublishedPackagePackageVersionBody] = None
    body_html: Optional[StrictStr] = None
    container_metadata: Optional[WebhookRegistryPackagePublishedRegistryPackagePackageVersionContainerMetadata] = None
    created_at: Optional[StrictStr] = None
    description: StrictStr
    docker_metadata: Optional[List[WebhookPackagePublishedPackagePackageVersionDockerMetadataInner]] = None
    draft: Optional[StrictBool] = None
    html_url: StrictStr
    id: StrictInt
    installation_command: StrictStr
    manifest: Optional[StrictStr] = None
    metadata: List[Dict[str, Any]]
    name: StrictStr
    npm_metadata: Optional[WebhookRegistryPackagePublishedRegistryPackagePackageVersionNpmMetadata] = None
    nuget_metadata: Optional[List[WebhookRegistryPackagePublishedRegistryPackagePackageVersionNugetMetadataInner]] = None
    package_files: List[WebhookRegistryPackagePublishedRegistryPackagePackageVersionPackageFilesInner]
    package_url: StrictStr
    prerelease: Optional[StrictBool] = None
    release: Optional[WebhookRegistryPackagePublishedRegistryPackagePackageVersionRelease] = None
    rubygems_metadata: Optional[List[WebhookRubygemsMetadata]] = None
    summary: StrictStr
    tag_name: Optional[StrictStr] = None
    target_commitish: Optional[StrictStr] = None
    target_oid: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    version: StrictStr
    __properties: ClassVar[List[str]] = ["author", "body", "body_html", "container_metadata", "created_at", "description", "docker_metadata", "draft", "html_url", "id", "installation_command", "manifest", "metadata", "name", "npm_metadata", "nuget_metadata", "package_files", "package_url", "prerelease", "release", "rubygems_metadata", "summary", "tag_name", "target_commitish", "target_oid", "updated_at", "version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookRegistryPackagePublishedRegistryPackagePackageVersion from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of author
        if self.author:
            _dict['author'] = self.author.to_dict()
        # override the default output from pydantic by calling `to_dict()` of body
        if self.body:
            _dict['body'] = self.body.to_dict()
        # override the default output from pydantic by calling `to_dict()` of container_metadata
        if self.container_metadata:
            _dict['container_metadata'] = self.container_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in docker_metadata (list)
        _items = []
        if self.docker_metadata:
            for _item_docker_metadata in self.docker_metadata:
                if _item_docker_metadata:
                    _items.append(_item_docker_metadata.to_dict())
            _dict['docker_metadata'] = _items
        # override the default output from pydantic by calling `to_dict()` of npm_metadata
        if self.npm_metadata:
            _dict['npm_metadata'] = self.npm_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in nuget_metadata (list)
        _items = []
        if self.nuget_metadata:
            for _item_nuget_metadata in self.nuget_metadata:
                if _item_nuget_metadata:
                    _items.append(_item_nuget_metadata.to_dict())
            _dict['nuget_metadata'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in package_files (list)
        _items = []
        if self.package_files:
            for _item_package_files in self.package_files:
                if _item_package_files:
                    _items.append(_item_package_files.to_dict())
            _dict['package_files'] = _items
        # override the default output from pydantic by calling `to_dict()` of release
        if self.release:
            _dict['release'] = self.release.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in rubygems_metadata (list)
        _items = []
        if self.rubygems_metadata:
            for _item_rubygems_metadata in self.rubygems_metadata:
                if _item_rubygems_metadata:
                    _items.append(_item_rubygems_metadata.to_dict())
            _dict['rubygems_metadata'] = _items
        # set to None if npm_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.npm_metadata is None and "npm_metadata" in self.model_fields_set:
            _dict['npm_metadata'] = None

        # set to None if nuget_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.nuget_metadata is None and "nuget_metadata" in self.model_fields_set:
            _dict['nuget_metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookRegistryPackagePublishedRegistryPackagePackageVersion from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "author": WebhookRegistryPackagePublishedRegistryPackageOwner.from_dict(obj["author"]) if obj.get("author") is not None else None,
            "body": WebhookPackagePublishedPackagePackageVersionBody.from_dict(obj["body"]) if obj.get("body") is not None else None,
            "body_html": obj.get("body_html"),
            "container_metadata": WebhookRegistryPackagePublishedRegistryPackagePackageVersionContainerMetadata.from_dict(obj["container_metadata"]) if obj.get("container_metadata") is not None else None,
            "created_at": obj.get("created_at"),
            "description": obj.get("description"),
            "docker_metadata": [WebhookPackagePublishedPackagePackageVersionDockerMetadataInner.from_dict(_item) for _item in obj["docker_metadata"]] if obj.get("docker_metadata") is not None else None,
            "draft": obj.get("draft"),
            "html_url": obj.get("html_url"),
            "id": obj.get("id"),
            "installation_command": obj.get("installation_command"),
            "manifest": obj.get("manifest"),
            "metadata": obj.get("metadata"),
            "name": obj.get("name"),
            "npm_metadata": WebhookRegistryPackagePublishedRegistryPackagePackageVersionNpmMetadata.from_dict(obj["npm_metadata"]) if obj.get("npm_metadata") is not None else None,
            "nuget_metadata": [WebhookRegistryPackagePublishedRegistryPackagePackageVersionNugetMetadataInner.from_dict(_item) for _item in obj["nuget_metadata"]] if obj.get("nuget_metadata") is not None else None,
            "package_files": [WebhookRegistryPackagePublishedRegistryPackagePackageVersionPackageFilesInner.from_dict(_item) for _item in obj["package_files"]] if obj.get("package_files") is not None else None,
            "package_url": obj.get("package_url"),
            "prerelease": obj.get("prerelease"),
            "release": WebhookRegistryPackagePublishedRegistryPackagePackageVersionRelease.from_dict(obj["release"]) if obj.get("release") is not None else None,
            "rubygems_metadata": [WebhookRubygemsMetadata.from_dict(_item) for _item in obj["rubygems_metadata"]] if obj.get("rubygems_metadata") is not None else None,
            "summary": obj.get("summary"),
            "tag_name": obj.get("tag_name"),
            "target_commitish": obj.get("target_commitish"),
            "target_oid": obj.get("target_oid"),
            "updated_at": obj.get("updated_at"),
            "version": obj.get("version")
        })
        return _obj


