# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.webhook_label_edited_changes_name import WebhookLabelEditedChangesName
from devopso.clients.github.models.webhook_project_edited_changes_body import WebhookProjectEditedChangesBody
from devopso.clients.github.models.webhook_release_edited_changes_make_latest import WebhookReleaseEditedChangesMakeLatest
from devopso.clients.github.models.webhook_release_edited_changes_tag_name import WebhookReleaseEditedChangesTagName
from typing import Optional, Set
from typing_extensions import Self

class WebhookReleaseEditedChanges(BaseModel):
    """
    WebhookReleaseEditedChanges
    """ # noqa: E501
    body: Optional[WebhookProjectEditedChangesBody] = None
    name: Optional[WebhookLabelEditedChangesName] = None
    tag_name: Optional[WebhookReleaseEditedChangesTagName] = None
    make_latest: Optional[WebhookReleaseEditedChangesMakeLatest] = None
    __properties: ClassVar[List[str]] = ["body", "name", "tag_name", "make_latest"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookReleaseEditedChanges from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of body
        if self.body:
            _dict['body'] = self.body.to_dict()
        # override the default output from pydantic by calling `to_dict()` of name
        if self.name:
            _dict['name'] = self.name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tag_name
        if self.tag_name:
            _dict['tag_name'] = self.tag_name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of make_latest
        if self.make_latest:
            _dict['make_latest'] = self.make_latest.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookReleaseEditedChanges from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "body": WebhookProjectEditedChangesBody.from_dict(obj["body"]) if obj.get("body") is not None else None,
            "name": WebhookLabelEditedChangesName.from_dict(obj["name"]) if obj.get("name") is not None else None,
            "tag_name": WebhookReleaseEditedChangesTagName.from_dict(obj["tag_name"]) if obj.get("tag_name") is not None else None,
            "make_latest": WebhookReleaseEditedChangesMakeLatest.from_dict(obj["make_latest"]) if obj.get("make_latest") is not None else None
        })
        return _obj


