# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.webhook_discussion_comment_edited_changes_body import WebhookDiscussionCommentEditedChangesBody
from devopso.clients.github.models.webhook_project_card_edited_changes_note import WebhookProjectCardEditedChangesNote
from devopso.clients.github.models.webhook_repository_edited_changes_topics import WebhookRepositoryEditedChangesTopics
from typing import Optional, Set
from typing_extensions import Self

class WebhookRepositoryEditedChanges(BaseModel):
    """
    WebhookRepositoryEditedChanges
    """ # noqa: E501
    default_branch: Optional[WebhookDiscussionCommentEditedChangesBody] = None
    description: Optional[WebhookProjectCardEditedChangesNote] = None
    homepage: Optional[WebhookProjectCardEditedChangesNote] = None
    topics: Optional[WebhookRepositoryEditedChangesTopics] = None
    __properties: ClassVar[List[str]] = ["default_branch", "description", "homepage", "topics"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookRepositoryEditedChanges from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of default_branch
        if self.default_branch:
            _dict['default_branch'] = self.default_branch.to_dict()
        # override the default output from pydantic by calling `to_dict()` of description
        if self.description:
            _dict['description'] = self.description.to_dict()
        # override the default output from pydantic by calling `to_dict()` of homepage
        if self.homepage:
            _dict['homepage'] = self.homepage.to_dict()
        # override the default output from pydantic by calling `to_dict()` of topics
        if self.topics:
            _dict['topics'] = self.topics.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookRepositoryEditedChanges from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "default_branch": WebhookDiscussionCommentEditedChangesBody.from_dict(obj["default_branch"]) if obj.get("default_branch") is not None else None,
            "description": WebhookProjectCardEditedChangesNote.from_dict(obj["description"]) if obj.get("description") is not None else None,
            "homepage": WebhookProjectCardEditedChangesNote.from_dict(obj["homepage"]) if obj.get("homepage") is not None else None,
            "topics": WebhookRepositoryEditedChangesTopics.from_dict(obj["topics"]) if obj.get("topics") is not None else None
        })
        return _obj


