# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.webhook_organization_renamed_changes_login import WebhookOrganizationRenamedChangesLogin
from devopso.clients.github.models.webhook_repository_ruleset_edited_changes_conditions import WebhookRepositoryRulesetEditedChangesConditions
from devopso.clients.github.models.webhook_repository_ruleset_edited_changes_rules import WebhookRepositoryRulesetEditedChangesRules
from typing import Optional, Set
from typing_extensions import Self

class WebhookRepositoryRulesetEditedChanges(BaseModel):
    """
    WebhookRepositoryRulesetEditedChanges
    """ # noqa: E501
    name: Optional[WebhookOrganizationRenamedChangesLogin] = None
    enforcement: Optional[WebhookOrganizationRenamedChangesLogin] = None
    conditions: Optional[WebhookRepositoryRulesetEditedChangesConditions] = None
    rules: Optional[WebhookRepositoryRulesetEditedChangesRules] = None
    __properties: ClassVar[List[str]] = ["name", "enforcement", "conditions", "rules"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookRepositoryRulesetEditedChanges from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of name
        if self.name:
            _dict['name'] = self.name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of enforcement
        if self.enforcement:
            _dict['enforcement'] = self.enforcement.to_dict()
        # override the default output from pydantic by calling `to_dict()` of conditions
        if self.conditions:
            _dict['conditions'] = self.conditions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rules
        if self.rules:
            _dict['rules'] = self.rules.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookRepositoryRulesetEditedChanges from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": WebhookOrganizationRenamedChangesLogin.from_dict(obj["name"]) if obj.get("name") is not None else None,
            "enforcement": WebhookOrganizationRenamedChangesLogin.from_dict(obj["enforcement"]) if obj.get("enforcement") is not None else None,
            "conditions": WebhookRepositoryRulesetEditedChangesConditions.from_dict(obj["conditions"]) if obj.get("conditions") is not None else None,
            "rules": WebhookRepositoryRulesetEditedChangesRules.from_dict(obj["rules"]) if obj.get("rules") is not None else None
        })
        return _obj


