# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.cvss_severities import CvssSeverities
from devopso.clients.github.models.webhooks_security_advisory_cvss import WebhooksSecurityAdvisoryCvss
from devopso.clients.github.models.webhooks_security_advisory_cwes_inner import WebhooksSecurityAdvisoryCwesInner
from devopso.clients.github.models.webhooks_security_advisory_identifiers_inner import WebhooksSecurityAdvisoryIdentifiersInner
from devopso.clients.github.models.webhooks_security_advisory_references_inner import WebhooksSecurityAdvisoryReferencesInner
from devopso.clients.github.models.webhooks_security_advisory_vulnerabilities_inner import WebhooksSecurityAdvisoryVulnerabilitiesInner
from typing import Optional, Set
from typing_extensions import Self

class WebhookSecurityAdvisoryWithdrawnSecurityAdvisory(BaseModel):
    """
    The details of the security advisory, including summary, description, and severity.
    """ # noqa: E501
    cvss: WebhooksSecurityAdvisoryCvss
    cvss_severities: Optional[CvssSeverities] = None
    cwes: List[WebhooksSecurityAdvisoryCwesInner]
    description: StrictStr
    ghsa_id: StrictStr
    identifiers: List[WebhooksSecurityAdvisoryIdentifiersInner]
    published_at: StrictStr
    references: List[WebhooksSecurityAdvisoryReferencesInner]
    severity: StrictStr
    summary: StrictStr
    updated_at: StrictStr
    vulnerabilities: List[WebhooksSecurityAdvisoryVulnerabilitiesInner]
    withdrawn_at: StrictStr
    __properties: ClassVar[List[str]] = ["cvss", "cvss_severities", "cwes", "description", "ghsa_id", "identifiers", "published_at", "references", "severity", "summary", "updated_at", "vulnerabilities", "withdrawn_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookSecurityAdvisoryWithdrawnSecurityAdvisory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cvss
        if self.cvss:
            _dict['cvss'] = self.cvss.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cvss_severities
        if self.cvss_severities:
            _dict['cvss_severities'] = self.cvss_severities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in cwes (list)
        _items = []
        if self.cwes:
            for _item_cwes in self.cwes:
                if _item_cwes:
                    _items.append(_item_cwes.to_dict())
            _dict['cwes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in identifiers (list)
        _items = []
        if self.identifiers:
            for _item_identifiers in self.identifiers:
                if _item_identifiers:
                    _items.append(_item_identifiers.to_dict())
            _dict['identifiers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item_references in self.references:
                if _item_references:
                    _items.append(_item_references.to_dict())
            _dict['references'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in vulnerabilities (list)
        _items = []
        if self.vulnerabilities:
            for _item_vulnerabilities in self.vulnerabilities:
                if _item_vulnerabilities:
                    _items.append(_item_vulnerabilities.to_dict())
            _dict['vulnerabilities'] = _items
        # set to None if cvss_severities (nullable) is None
        # and model_fields_set contains the field
        if self.cvss_severities is None and "cvss_severities" in self.model_fields_set:
            _dict['cvss_severities'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookSecurityAdvisoryWithdrawnSecurityAdvisory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cvss": WebhooksSecurityAdvisoryCvss.from_dict(obj["cvss"]) if obj.get("cvss") is not None else None,
            "cvss_severities": CvssSeverities.from_dict(obj["cvss_severities"]) if obj.get("cvss_severities") is not None else None,
            "cwes": [WebhooksSecurityAdvisoryCwesInner.from_dict(_item) for _item in obj["cwes"]] if obj.get("cwes") is not None else None,
            "description": obj.get("description"),
            "ghsa_id": obj.get("ghsa_id"),
            "identifiers": [WebhooksSecurityAdvisoryIdentifiersInner.from_dict(_item) for _item in obj["identifiers"]] if obj.get("identifiers") is not None else None,
            "published_at": obj.get("published_at"),
            "references": [WebhooksSecurityAdvisoryReferencesInner.from_dict(_item) for _item in obj["references"]] if obj.get("references") is not None else None,
            "severity": obj.get("severity"),
            "summary": obj.get("summary"),
            "updated_at": obj.get("updated_at"),
            "vulnerabilities": [WebhooksSecurityAdvisoryVulnerabilitiesInner.from_dict(_item) for _item in obj["vulnerabilities"]] if obj.get("vulnerabilities") is not None else None,
            "withdrawn_at": obj.get("withdrawn_at")
        })
        return _obj


