# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.enterprise_webhooks import EnterpriseWebhooks
from devopso.clients.github.models.organization_simple_webhooks import OrganizationSimpleWebhooks
from devopso.clients.github.models.repository_webhooks import RepositoryWebhooks
from devopso.clients.github.models.simple_installation import SimpleInstallation
from devopso.clients.github.models.simple_user import SimpleUser
from devopso.clients.github.models.webhook_status_branches_inner import WebhookStatusBranchesInner
from devopso.clients.github.models.webhook_status_commit import WebhookStatusCommit
from typing import Optional, Set
from typing_extensions import Self

class WebhookStatus(BaseModel):
    """
    WebhookStatus
    """ # noqa: E501
    avatar_url: Optional[StrictStr] = None
    branches: List[WebhookStatusBranchesInner] = Field(description="An array of branch objects containing the status' SHA. Each branch contains the given SHA, but the SHA may or may not be the head of the branch. The array includes a maximum of 10 branches.")
    commit: WebhookStatusCommit
    context: StrictStr
    created_at: StrictStr
    description: Optional[StrictStr] = Field(description="The optional human-readable description added to the status.")
    enterprise: Optional[EnterpriseWebhooks] = None
    id: StrictInt = Field(description="The unique identifier of the status.")
    installation: Optional[SimpleInstallation] = None
    name: StrictStr
    organization: Optional[OrganizationSimpleWebhooks] = None
    repository: RepositoryWebhooks
    sender: SimpleUser
    sha: StrictStr = Field(description="The Commit SHA.")
    state: StrictStr = Field(description="The new state. Can be `pending`, `success`, `failure`, or `error`.")
    target_url: Optional[StrictStr] = Field(description="The optional link added to the status.")
    updated_at: StrictStr
    __properties: ClassVar[List[str]] = ["avatar_url", "branches", "commit", "context", "created_at", "description", "enterprise", "id", "installation", "name", "organization", "repository", "sender", "sha", "state", "target_url", "updated_at"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['pending', 'success', 'failure', 'error']):
            raise ValueError("must be one of enum values ('pending', 'success', 'failure', 'error')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in branches (list)
        _items = []
        if self.branches:
            for _item_branches in self.branches:
                if _item_branches:
                    _items.append(_item_branches.to_dict())
            _dict['branches'] = _items
        # override the default output from pydantic by calling `to_dict()` of commit
        if self.commit:
            _dict['commit'] = self.commit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of enterprise
        if self.enterprise:
            _dict['enterprise'] = self.enterprise.to_dict()
        # override the default output from pydantic by calling `to_dict()` of installation
        if self.installation:
            _dict['installation'] = self.installation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict['organization'] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of repository
        if self.repository:
            _dict['repository'] = self.repository.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sender
        if self.sender:
            _dict['sender'] = self.sender.to_dict()
        # set to None if avatar_url (nullable) is None
        # and model_fields_set contains the field
        if self.avatar_url is None and "avatar_url" in self.model_fields_set:
            _dict['avatar_url'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if target_url (nullable) is None
        # and model_fields_set contains the field
        if self.target_url is None and "target_url" in self.model_fields_set:
            _dict['target_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "avatar_url": obj.get("avatar_url"),
            "branches": [WebhookStatusBranchesInner.from_dict(_item) for _item in obj["branches"]] if obj.get("branches") is not None else None,
            "commit": WebhookStatusCommit.from_dict(obj["commit"]) if obj.get("commit") is not None else None,
            "context": obj.get("context"),
            "created_at": obj.get("created_at"),
            "description": obj.get("description"),
            "enterprise": EnterpriseWebhooks.from_dict(obj["enterprise"]) if obj.get("enterprise") is not None else None,
            "id": obj.get("id"),
            "installation": SimpleInstallation.from_dict(obj["installation"]) if obj.get("installation") is not None else None,
            "name": obj.get("name"),
            "organization": OrganizationSimpleWebhooks.from_dict(obj["organization"]) if obj.get("organization") is not None else None,
            "repository": RepositoryWebhooks.from_dict(obj["repository"]) if obj.get("repository") is not None else None,
            "sender": SimpleUser.from_dict(obj["sender"]) if obj.get("sender") is not None else None,
            "sha": obj.get("sha"),
            "state": obj.get("state"),
            "target_url": obj.get("target_url"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


