# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.user8 import User8
from devopso.clients.github.models.webhook_status_commit_commit import WebhookStatusCommitCommit
from devopso.clients.github.models.webhook_status_commit_parents_inner import WebhookStatusCommitParentsInner
from typing import Optional, Set
from typing_extensions import Self

class WebhookStatusCommit(BaseModel):
    """
    WebhookStatusCommit
    """ # noqa: E501
    author: Optional[User8]
    comments_url: StrictStr
    commit: WebhookStatusCommitCommit
    committer: Optional[User8]
    html_url: StrictStr
    node_id: StrictStr
    parents: List[WebhookStatusCommitParentsInner]
    sha: StrictStr
    url: StrictStr
    __properties: ClassVar[List[str]] = ["author", "comments_url", "commit", "committer", "html_url", "node_id", "parents", "sha", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookStatusCommit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of author
        if self.author:
            _dict['author'] = self.author.to_dict()
        # override the default output from pydantic by calling `to_dict()` of commit
        if self.commit:
            _dict['commit'] = self.commit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of committer
        if self.committer:
            _dict['committer'] = self.committer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in parents (list)
        _items = []
        if self.parents:
            for _item_parents in self.parents:
                if _item_parents:
                    _items.append(_item_parents.to_dict())
            _dict['parents'] = _items
        # set to None if author (nullable) is None
        # and model_fields_set contains the field
        if self.author is None and "author" in self.model_fields_set:
            _dict['author'] = None

        # set to None if committer (nullable) is None
        # and model_fields_set contains the field
        if self.committer is None and "committer" in self.model_fields_set:
            _dict['committer'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookStatusCommit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "author": User8.from_dict(obj["author"]) if obj.get("author") is not None else None,
            "comments_url": obj.get("comments_url"),
            "commit": WebhookStatusCommitCommit.from_dict(obj["commit"]) if obj.get("commit") is not None else None,
            "committer": User8.from_dict(obj["committer"]) if obj.get("committer") is not None else None,
            "html_url": obj.get("html_url"),
            "node_id": obj.get("node_id"),
            "parents": [WebhookStatusCommitParentsInner.from_dict(_item) for _item in obj["parents"]] if obj.get("parents") is not None else None,
            "sha": obj.get("sha"),
            "url": obj.get("url")
        })
        return _obj


