# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class WebhookStatusCommitCommitVerification(BaseModel):
    """
    WebhookStatusCommitCommitVerification
    """ # noqa: E501
    payload: Optional[StrictStr]
    reason: StrictStr
    signature: Optional[StrictStr]
    verified: StrictBool
    verified_at: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["payload", "reason", "signature", "verified", "verified_at"]

    @field_validator('reason')
    def reason_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['expired_key', 'not_signing_key', 'gpgverify_error', 'gpgverify_unavailable', 'unsigned', 'unknown_signature_type', 'no_user', 'unverified_email', 'bad_email', 'unknown_key', 'malformed_signature', 'invalid', 'valid', 'bad_cert', 'ocsp_pending']):
            raise ValueError("must be one of enum values ('expired_key', 'not_signing_key', 'gpgverify_error', 'gpgverify_unavailable', 'unsigned', 'unknown_signature_type', 'no_user', 'unverified_email', 'bad_email', 'unknown_key', 'malformed_signature', 'invalid', 'valid', 'bad_cert', 'ocsp_pending')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookStatusCommitCommitVerification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if payload (nullable) is None
        # and model_fields_set contains the field
        if self.payload is None and "payload" in self.model_fields_set:
            _dict['payload'] = None

        # set to None if signature (nullable) is None
        # and model_fields_set contains the field
        if self.signature is None and "signature" in self.model_fields_set:
            _dict['signature'] = None

        # set to None if verified_at (nullable) is None
        # and model_fields_set contains the field
        if self.verified_at is None and "verified_at" in self.model_fields_set:
            _dict['verified_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookStatusCommitCommitVerification from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "payload": obj.get("payload"),
            "reason": obj.get("reason"),
            "signature": obj.get("signature"),
            "verified": obj.get("verified"),
            "verified_at": obj.get("verified_at")
        })
        return _obj


