# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class WebhookWorkflowJobCompletedWorkflowJob(BaseModel):
    """
    WebhookWorkflowJobCompletedWorkflowJob
    """ # noqa: E501
    check_run_url: StrictStr
    completed_at: StrictStr
    conclusion: StrictStr
    created_at: StrictStr = Field(description="The time that the job created.")
    head_sha: StrictStr
    html_url: StrictStr
    id: StrictInt
    labels: List[Optional[StrictStr]]
    name: StrictStr
    node_id: StrictStr
    run_attempt: StrictInt
    run_id: StrictInt
    run_url: StrictStr
    runner_group_id: Optional[Union[StrictFloat, StrictInt]]
    runner_group_name: Optional[StrictStr]
    runner_id: Optional[Union[StrictFloat, StrictInt]]
    runner_name: Optional[StrictStr]
    started_at: StrictStr
    status: StrictStr
    head_branch: Optional[StrictStr] = Field(description="The name of the current branch.")
    workflow_name: Optional[StrictStr] = Field(description="The name of the workflow.")
    steps: List[Optional[Dict[str, Any]]]
    url: StrictStr
    __properties: ClassVar[List[str]] = ["check_run_url", "completed_at", "conclusion", "created_at", "head_sha", "html_url", "id", "labels", "name", "node_id", "run_attempt", "run_id", "run_url", "runner_group_id", "runner_group_name", "runner_id", "runner_name", "started_at", "status", "head_branch", "workflow_name", "steps", "url"]

    @field_validator('conclusion')
    def conclusion_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['success', 'failure', 'skipped', 'cancelled', 'action_required', 'neutral', 'timed_out']):
            raise ValueError("must be one of enum values ('success', 'failure', 'skipped', 'cancelled', 'action_required', 'neutral', 'timed_out')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookWorkflowJobCompletedWorkflowJob from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if runner_group_id (nullable) is None
        # and model_fields_set contains the field
        if self.runner_group_id is None and "runner_group_id" in self.model_fields_set:
            _dict['runner_group_id'] = None

        # set to None if runner_group_name (nullable) is None
        # and model_fields_set contains the field
        if self.runner_group_name is None and "runner_group_name" in self.model_fields_set:
            _dict['runner_group_name'] = None

        # set to None if runner_id (nullable) is None
        # and model_fields_set contains the field
        if self.runner_id is None and "runner_id" in self.model_fields_set:
            _dict['runner_id'] = None

        # set to None if runner_name (nullable) is None
        # and model_fields_set contains the field
        if self.runner_name is None and "runner_name" in self.model_fields_set:
            _dict['runner_name'] = None

        # set to None if head_branch (nullable) is None
        # and model_fields_set contains the field
        if self.head_branch is None and "head_branch" in self.model_fields_set:
            _dict['head_branch'] = None

        # set to None if workflow_name (nullable) is None
        # and model_fields_set contains the field
        if self.workflow_name is None and "workflow_name" in self.model_fields_set:
            _dict['workflow_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookWorkflowJobCompletedWorkflowJob from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "check_run_url": obj.get("check_run_url"),
            "completed_at": obj.get("completed_at"),
            "conclusion": obj.get("conclusion"),
            "created_at": obj.get("created_at"),
            "head_sha": obj.get("head_sha"),
            "html_url": obj.get("html_url"),
            "id": obj.get("id"),
            "labels": obj.get("labels"),
            "name": obj.get("name"),
            "node_id": obj.get("node_id"),
            "run_attempt": obj.get("run_attempt"),
            "run_id": obj.get("run_id"),
            "run_url": obj.get("run_url"),
            "runner_group_id": obj.get("runner_group_id"),
            "runner_group_name": obj.get("runner_group_name"),
            "runner_id": obj.get("runner_id"),
            "runner_name": obj.get("runner_name"),
            "started_at": obj.get("started_at"),
            "status": obj.get("status"),
            "head_branch": obj.get("head_branch"),
            "workflow_name": obj.get("workflow_name"),
            "steps": obj.get("steps"),
            "url": obj.get("url")
        })
        return _obj


