# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class WebhooksProjectColumn(BaseModel):
    """
    WebhooksProjectColumn
    """ # noqa: E501
    after_id: Optional[StrictInt] = None
    cards_url: StrictStr
    created_at: datetime
    id: StrictInt = Field(description="The unique identifier of the project column")
    name: StrictStr = Field(description="Name of the project column")
    node_id: StrictStr
    project_url: StrictStr
    updated_at: datetime
    url: StrictStr
    __properties: ClassVar[List[str]] = ["after_id", "cards_url", "created_at", "id", "name", "node_id", "project_url", "updated_at", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhooksProjectColumn from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if after_id (nullable) is None
        # and model_fields_set contains the field
        if self.after_id is None and "after_id" in self.model_fields_set:
            _dict['after_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhooksProjectColumn from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "after_id": obj.get("after_id"),
            "cards_url": obj.get("cards_url"),
            "created_at": obj.get("created_at"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "node_id": obj.get("node_id"),
            "project_url": obj.get("project_url"),
            "updated_at": obj.get("updated_at"),
            "url": obj.get("url")
        })
        return _obj


