# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.reactions import Reactions
from devopso.clients.github.models.release_asset import ReleaseAsset
from devopso.clients.github.models.user2 import User2
from typing import Optional, Set
from typing_extensions import Self

class WebhooksRelease(BaseModel):
    """
    The [release](https://docs.github.com/rest/releases/releases/#get-a-release) object.
    """ # noqa: E501
    assets: List[ReleaseAsset]
    assets_url: StrictStr
    author: Optional[User2]
    body: Optional[StrictStr]
    created_at: Optional[datetime]
    updated_at: Optional[datetime]
    discussion_url: Optional[StrictStr] = None
    draft: StrictBool = Field(description="Whether the release is a draft or published")
    html_url: StrictStr
    id: StrictInt
    immutable: StrictBool = Field(description="Whether or not the release is immutable.")
    name: Optional[StrictStr]
    node_id: StrictStr
    prerelease: StrictBool = Field(description="Whether the release is identified as a prerelease or a full release.")
    published_at: Optional[datetime]
    reactions: Optional[Reactions] = None
    tag_name: StrictStr = Field(description="The name of the tag.")
    tarball_url: Optional[StrictStr]
    target_commitish: StrictStr = Field(description="Specifies the commitish value that determines where the Git tag is created from.")
    upload_url: StrictStr
    url: StrictStr
    zipball_url: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["assets", "assets_url", "author", "body", "created_at", "updated_at", "discussion_url", "draft", "html_url", "id", "immutable", "name", "node_id", "prerelease", "published_at", "reactions", "tag_name", "tarball_url", "target_commitish", "upload_url", "url", "zipball_url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhooksRelease from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in assets (list)
        _items = []
        if self.assets:
            for _item_assets in self.assets:
                if _item_assets:
                    _items.append(_item_assets.to_dict())
            _dict['assets'] = _items
        # override the default output from pydantic by calling `to_dict()` of author
        if self.author:
            _dict['author'] = self.author.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reactions
        if self.reactions:
            _dict['reactions'] = self.reactions.to_dict()
        # set to None if author (nullable) is None
        # and model_fields_set contains the field
        if self.author is None and "author" in self.model_fields_set:
            _dict['author'] = None

        # set to None if body (nullable) is None
        # and model_fields_set contains the field
        if self.body is None and "body" in self.model_fields_set:
            _dict['body'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['created_at'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updated_at'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if published_at (nullable) is None
        # and model_fields_set contains the field
        if self.published_at is None and "published_at" in self.model_fields_set:
            _dict['published_at'] = None

        # set to None if tarball_url (nullable) is None
        # and model_fields_set contains the field
        if self.tarball_url is None and "tarball_url" in self.model_fields_set:
            _dict['tarball_url'] = None

        # set to None if zipball_url (nullable) is None
        # and model_fields_set contains the field
        if self.zipball_url is None and "zipball_url" in self.model_fields_set:
            _dict['zipball_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhooksRelease from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assets": [ReleaseAsset.from_dict(_item) for _item in obj["assets"]] if obj.get("assets") is not None else None,
            "assets_url": obj.get("assets_url"),
            "author": User2.from_dict(obj["author"]) if obj.get("author") is not None else None,
            "body": obj.get("body"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "discussion_url": obj.get("discussion_url"),
            "draft": obj.get("draft"),
            "html_url": obj.get("html_url"),
            "id": obj.get("id"),
            "immutable": obj.get("immutable"),
            "name": obj.get("name"),
            "node_id": obj.get("node_id"),
            "prerelease": obj.get("prerelease"),
            "published_at": obj.get("published_at"),
            "reactions": Reactions.from_dict(obj["reactions"]) if obj.get("reactions") is not None else None,
            "tag_name": obj.get("tag_name"),
            "tarball_url": obj.get("tarball_url"),
            "target_commitish": obj.get("target_commitish"),
            "upload_url": obj.get("upload_url"),
            "url": obj.get("url"),
            "zipball_url": obj.get("zipball_url")
        })
        return _obj


