# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.user1 import User1
from devopso.clients.github.models.webhooks_review_links import WebhooksReviewLinks
from typing import Optional, Set
from typing_extensions import Self

class WebhooksReview(BaseModel):
    """
    The review that was affected.
    """ # noqa: E501
    links: WebhooksReviewLinks = Field(alias="_links")
    author_association: StrictStr = Field(description="How the author is associated with the repository.")
    body: Optional[StrictStr] = Field(description="The text of the review.")
    commit_id: StrictStr = Field(description="A commit SHA for the review.")
    html_url: StrictStr
    id: StrictInt = Field(description="Unique identifier of the review")
    node_id: StrictStr
    pull_request_url: StrictStr
    state: StrictStr
    submitted_at: Optional[datetime]
    updated_at: Optional[datetime] = None
    user: Optional[User1]
    __properties: ClassVar[List[str]] = ["_links", "author_association", "body", "commit_id", "html_url", "id", "node_id", "pull_request_url", "state", "submitted_at", "updated_at", "user"]

    @field_validator('author_association')
    def author_association_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['COLLABORATOR', 'CONTRIBUTOR', 'FIRST_TIMER', 'FIRST_TIME_CONTRIBUTOR', 'MANNEQUIN', 'MEMBER', 'NONE', 'OWNER']):
            raise ValueError("must be one of enum values ('COLLABORATOR', 'CONTRIBUTOR', 'FIRST_TIMER', 'FIRST_TIME_CONTRIBUTOR', 'MANNEQUIN', 'MEMBER', 'NONE', 'OWNER')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhooksReview from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['_links'] = self.links.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # set to None if body (nullable) is None
        # and model_fields_set contains the field
        if self.body is None and "body" in self.model_fields_set:
            _dict['body'] = None

        # set to None if submitted_at (nullable) is None
        # and model_fields_set contains the field
        if self.submitted_at is None and "submitted_at" in self.model_fields_set:
            _dict['submitted_at'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updated_at'] = None

        # set to None if user (nullable) is None
        # and model_fields_set contains the field
        if self.user is None and "user" in self.model_fields_set:
            _dict['user'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhooksReview from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_links": WebhooksReviewLinks.from_dict(obj["_links"]) if obj.get("_links") is not None else None,
            "author_association": obj.get("author_association"),
            "body": obj.get("body"),
            "commit_id": obj.get("commit_id"),
            "html_url": obj.get("html_url"),
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "pull_request_url": obj.get("pull_request_url"),
            "state": obj.get("state"),
            "submitted_at": obj.get("submitted_at"),
            "updated_at": obj.get("updated_at"),
            "user": User1.from_dict(obj["user"]) if obj.get("user") is not None else None
        })
        return _obj


