# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.sponsorship_tier import SponsorshipTier
from devopso.clients.github.models.user2 import User2
from devopso.clients.github.models.webhooks_sponsorship_maintainer import WebhooksSponsorshipMaintainer
from typing import Optional, Set
from typing_extensions import Self

class WebhooksSponsorship(BaseModel):
    """
    WebhooksSponsorship
    """ # noqa: E501
    created_at: StrictStr
    maintainer: Optional[WebhooksSponsorshipMaintainer] = None
    node_id: StrictStr
    privacy_level: StrictStr
    sponsor: Optional[User2]
    sponsorable: Optional[User2]
    tier: SponsorshipTier
    __properties: ClassVar[List[str]] = ["created_at", "maintainer", "node_id", "privacy_level", "sponsor", "sponsorable", "tier"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhooksSponsorship from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of maintainer
        if self.maintainer:
            _dict['maintainer'] = self.maintainer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sponsor
        if self.sponsor:
            _dict['sponsor'] = self.sponsor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sponsorable
        if self.sponsorable:
            _dict['sponsorable'] = self.sponsorable.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tier
        if self.tier:
            _dict['tier'] = self.tier.to_dict()
        # set to None if sponsor (nullable) is None
        # and model_fields_set contains the field
        if self.sponsor is None and "sponsor" in self.model_fields_set:
            _dict['sponsor'] = None

        # set to None if sponsorable (nullable) is None
        # and model_fields_set contains the field
        if self.sponsorable is None and "sponsorable" in self.model_fields_set:
            _dict['sponsorable'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhooksSponsorship from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "maintainer": WebhooksSponsorshipMaintainer.from_dict(obj["maintainer"]) if obj.get("maintainer") is not None else None,
            "node_id": obj.get("node_id"),
            "privacy_level": obj.get("privacy_level"),
            "sponsor": User2.from_dict(obj["sponsor"]) if obj.get("sponsor") is not None else None,
            "sponsorable": User2.from_dict(obj["sponsorable"]) if obj.get("sponsorable") is not None else None,
            "tier": SponsorshipTier.from_dict(obj["tier"]) if obj.get("tier") is not None else None
        })
        return _obj


