# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud.models.found_users_and_groups import FoundUsersAndGroups

from devopso.clients.jira_cloud.api_client import ApiClient, RequestSerialized
from devopso.clients.jira_cloud.api_response import ApiResponse
from devopso.clients.jira_cloud.rest import RESTResponseType


class GroupAndUserPickerApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def find_users_and_groups(
        self,
        query: Annotated[StrictStr, Field(description="The search string.")],
        max_results: Annotated[Optional[StrictInt], Field(description="The maximum number of items to return in each list.")] = None,
        show_avatar: Annotated[Optional[StrictBool], Field(description="Whether the user avatar should be returned. If an invalid value is provided, the default value is used.")] = None,
        field_id: Annotated[Optional[StrictStr], Field(description="The custom field ID of the field this request is for.")] = None,
        project_id: Annotated[Optional[List[StrictStr]], Field(description="The ID of a project that returned users and groups must have permission to view. To include multiple projects, provide an ampersand-separated list. For example, `projectId=10000&projectId=10001`. This parameter is only used when `fieldId` is present.")] = None,
        issue_type_id: Annotated[Optional[List[StrictStr]], Field(description="The ID of an issue type that returned users and groups must have permission to view. To include multiple issue types, provide an ampersand-separated list. For example, `issueTypeId=10000&issueTypeId=10001`. Special values, such as `-1` (all standard issue types) and `-2` (all subtask issue types), are supported. This parameter is only used when `fieldId` is present.")] = None,
        avatar_size: Annotated[Optional[StrictStr], Field(description="The size of the avatar to return. If an invalid value is provided, the default value is used.")] = None,
        case_insensitive: Annotated[Optional[StrictBool], Field(description="Whether the search for groups should be case insensitive.")] = None,
        exclude_connect_addons: Annotated[Optional[StrictBool], Field(description="Whether Connect app users and groups should be excluded from the search results. If an invalid value is provided, the default value is used.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FoundUsersAndGroups:
        """Find users and groups

        Returns a list of users and groups matching a string. The string is used:   *  for users, to find a case-insensitive match with display name and e-mail address. Note that if a user has hidden their email address in their user profile, partial matches of the email address will not find the user. An exact match is required.  *  for groups, to find a case-sensitive match with group name.  For example, if the string *tin* is used, records with the display name *Tina*, email address *sarah@tinplatetraining.com*, and the group *accounting* would be returned.  Optionally, the search can be refined to:   *  the projects and issue types associated with a custom field, such as a user picker. The search can then be further refined to return only users and groups that have permission to view specific:           *  projects.      *  issue types.          If multiple projects or issue types are specified, they must be a subset of those enabled for the custom field or no results are returned. For example, if a field is enabled for projects A, B, and C then the search could be limited to projects B and C. However, if the search is limited to projects B and D, nothing is returned.  *  not return Connect app users and groups.  *  return groups that have a case-insensitive match with the query.  The primary use case for this resource is to populate a picker field suggestion list with users or groups. To this end, the returned object includes an `html` field for each list. This field highlights the matched query term in the item name with the HTML strong tag. Also, each list is wrapped in a response object that contains a header for use in a picker, specifically *Showing X of Y matching groups*.  This operation can be accessed anonymously.  **[Permissions](#permissions) required:** *Browse users and groups* [global permission](https://confluence.atlassian.com/x/yodKLg).

        :param query: The search string. (required)
        :type query: str
        :param max_results: The maximum number of items to return in each list.
        :type max_results: int
        :param show_avatar: Whether the user avatar should be returned. If an invalid value is provided, the default value is used.
        :type show_avatar: bool
        :param field_id: The custom field ID of the field this request is for.
        :type field_id: str
        :param project_id: The ID of a project that returned users and groups must have permission to view. To include multiple projects, provide an ampersand-separated list. For example, `projectId=10000&projectId=10001`. This parameter is only used when `fieldId` is present.
        :type project_id: List[str]
        :param issue_type_id: The ID of an issue type that returned users and groups must have permission to view. To include multiple issue types, provide an ampersand-separated list. For example, `issueTypeId=10000&issueTypeId=10001`. Special values, such as `-1` (all standard issue types) and `-2` (all subtask issue types), are supported. This parameter is only used when `fieldId` is present.
        :type issue_type_id: List[str]
        :param avatar_size: The size of the avatar to return. If an invalid value is provided, the default value is used.
        :type avatar_size: str
        :param case_insensitive: Whether the search for groups should be case insensitive.
        :type case_insensitive: bool
        :param exclude_connect_addons: Whether Connect app users and groups should be excluded from the search results. If an invalid value is provided, the default value is used.
        :type exclude_connect_addons: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._find_users_and_groups_serialize(
            query=query,
            max_results=max_results,
            show_avatar=show_avatar,
            field_id=field_id,
            project_id=project_id,
            issue_type_id=issue_type_id,
            avatar_size=avatar_size,
            case_insensitive=case_insensitive,
            exclude_connect_addons=exclude_connect_addons,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FoundUsersAndGroups",
            '400': None,
            '401': None,
            '403': None,
            '429': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def find_users_and_groups_with_http_info(
        self,
        query: Annotated[StrictStr, Field(description="The search string.")],
        max_results: Annotated[Optional[StrictInt], Field(description="The maximum number of items to return in each list.")] = None,
        show_avatar: Annotated[Optional[StrictBool], Field(description="Whether the user avatar should be returned. If an invalid value is provided, the default value is used.")] = None,
        field_id: Annotated[Optional[StrictStr], Field(description="The custom field ID of the field this request is for.")] = None,
        project_id: Annotated[Optional[List[StrictStr]], Field(description="The ID of a project that returned users and groups must have permission to view. To include multiple projects, provide an ampersand-separated list. For example, `projectId=10000&projectId=10001`. This parameter is only used when `fieldId` is present.")] = None,
        issue_type_id: Annotated[Optional[List[StrictStr]], Field(description="The ID of an issue type that returned users and groups must have permission to view. To include multiple issue types, provide an ampersand-separated list. For example, `issueTypeId=10000&issueTypeId=10001`. Special values, such as `-1` (all standard issue types) and `-2` (all subtask issue types), are supported. This parameter is only used when `fieldId` is present.")] = None,
        avatar_size: Annotated[Optional[StrictStr], Field(description="The size of the avatar to return. If an invalid value is provided, the default value is used.")] = None,
        case_insensitive: Annotated[Optional[StrictBool], Field(description="Whether the search for groups should be case insensitive.")] = None,
        exclude_connect_addons: Annotated[Optional[StrictBool], Field(description="Whether Connect app users and groups should be excluded from the search results. If an invalid value is provided, the default value is used.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FoundUsersAndGroups]:
        """Find users and groups

        Returns a list of users and groups matching a string. The string is used:   *  for users, to find a case-insensitive match with display name and e-mail address. Note that if a user has hidden their email address in their user profile, partial matches of the email address will not find the user. An exact match is required.  *  for groups, to find a case-sensitive match with group name.  For example, if the string *tin* is used, records with the display name *Tina*, email address *sarah@tinplatetraining.com*, and the group *accounting* would be returned.  Optionally, the search can be refined to:   *  the projects and issue types associated with a custom field, such as a user picker. The search can then be further refined to return only users and groups that have permission to view specific:           *  projects.      *  issue types.          If multiple projects or issue types are specified, they must be a subset of those enabled for the custom field or no results are returned. For example, if a field is enabled for projects A, B, and C then the search could be limited to projects B and C. However, if the search is limited to projects B and D, nothing is returned.  *  not return Connect app users and groups.  *  return groups that have a case-insensitive match with the query.  The primary use case for this resource is to populate a picker field suggestion list with users or groups. To this end, the returned object includes an `html` field for each list. This field highlights the matched query term in the item name with the HTML strong tag. Also, each list is wrapped in a response object that contains a header for use in a picker, specifically *Showing X of Y matching groups*.  This operation can be accessed anonymously.  **[Permissions](#permissions) required:** *Browse users and groups* [global permission](https://confluence.atlassian.com/x/yodKLg).

        :param query: The search string. (required)
        :type query: str
        :param max_results: The maximum number of items to return in each list.
        :type max_results: int
        :param show_avatar: Whether the user avatar should be returned. If an invalid value is provided, the default value is used.
        :type show_avatar: bool
        :param field_id: The custom field ID of the field this request is for.
        :type field_id: str
        :param project_id: The ID of a project that returned users and groups must have permission to view. To include multiple projects, provide an ampersand-separated list. For example, `projectId=10000&projectId=10001`. This parameter is only used when `fieldId` is present.
        :type project_id: List[str]
        :param issue_type_id: The ID of an issue type that returned users and groups must have permission to view. To include multiple issue types, provide an ampersand-separated list. For example, `issueTypeId=10000&issueTypeId=10001`. Special values, such as `-1` (all standard issue types) and `-2` (all subtask issue types), are supported. This parameter is only used when `fieldId` is present.
        :type issue_type_id: List[str]
        :param avatar_size: The size of the avatar to return. If an invalid value is provided, the default value is used.
        :type avatar_size: str
        :param case_insensitive: Whether the search for groups should be case insensitive.
        :type case_insensitive: bool
        :param exclude_connect_addons: Whether Connect app users and groups should be excluded from the search results. If an invalid value is provided, the default value is used.
        :type exclude_connect_addons: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._find_users_and_groups_serialize(
            query=query,
            max_results=max_results,
            show_avatar=show_avatar,
            field_id=field_id,
            project_id=project_id,
            issue_type_id=issue_type_id,
            avatar_size=avatar_size,
            case_insensitive=case_insensitive,
            exclude_connect_addons=exclude_connect_addons,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FoundUsersAndGroups",
            '400': None,
            '401': None,
            '403': None,
            '429': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def find_users_and_groups_without_preload_content(
        self,
        query: Annotated[StrictStr, Field(description="The search string.")],
        max_results: Annotated[Optional[StrictInt], Field(description="The maximum number of items to return in each list.")] = None,
        show_avatar: Annotated[Optional[StrictBool], Field(description="Whether the user avatar should be returned. If an invalid value is provided, the default value is used.")] = None,
        field_id: Annotated[Optional[StrictStr], Field(description="The custom field ID of the field this request is for.")] = None,
        project_id: Annotated[Optional[List[StrictStr]], Field(description="The ID of a project that returned users and groups must have permission to view. To include multiple projects, provide an ampersand-separated list. For example, `projectId=10000&projectId=10001`. This parameter is only used when `fieldId` is present.")] = None,
        issue_type_id: Annotated[Optional[List[StrictStr]], Field(description="The ID of an issue type that returned users and groups must have permission to view. To include multiple issue types, provide an ampersand-separated list. For example, `issueTypeId=10000&issueTypeId=10001`. Special values, such as `-1` (all standard issue types) and `-2` (all subtask issue types), are supported. This parameter is only used when `fieldId` is present.")] = None,
        avatar_size: Annotated[Optional[StrictStr], Field(description="The size of the avatar to return. If an invalid value is provided, the default value is used.")] = None,
        case_insensitive: Annotated[Optional[StrictBool], Field(description="Whether the search for groups should be case insensitive.")] = None,
        exclude_connect_addons: Annotated[Optional[StrictBool], Field(description="Whether Connect app users and groups should be excluded from the search results. If an invalid value is provided, the default value is used.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Find users and groups

        Returns a list of users and groups matching a string. The string is used:   *  for users, to find a case-insensitive match with display name and e-mail address. Note that if a user has hidden their email address in their user profile, partial matches of the email address will not find the user. An exact match is required.  *  for groups, to find a case-sensitive match with group name.  For example, if the string *tin* is used, records with the display name *Tina*, email address *sarah@tinplatetraining.com*, and the group *accounting* would be returned.  Optionally, the search can be refined to:   *  the projects and issue types associated with a custom field, such as a user picker. The search can then be further refined to return only users and groups that have permission to view specific:           *  projects.      *  issue types.          If multiple projects or issue types are specified, they must be a subset of those enabled for the custom field or no results are returned. For example, if a field is enabled for projects A, B, and C then the search could be limited to projects B and C. However, if the search is limited to projects B and D, nothing is returned.  *  not return Connect app users and groups.  *  return groups that have a case-insensitive match with the query.  The primary use case for this resource is to populate a picker field suggestion list with users or groups. To this end, the returned object includes an `html` field for each list. This field highlights the matched query term in the item name with the HTML strong tag. Also, each list is wrapped in a response object that contains a header for use in a picker, specifically *Showing X of Y matching groups*.  This operation can be accessed anonymously.  **[Permissions](#permissions) required:** *Browse users and groups* [global permission](https://confluence.atlassian.com/x/yodKLg).

        :param query: The search string. (required)
        :type query: str
        :param max_results: The maximum number of items to return in each list.
        :type max_results: int
        :param show_avatar: Whether the user avatar should be returned. If an invalid value is provided, the default value is used.
        :type show_avatar: bool
        :param field_id: The custom field ID of the field this request is for.
        :type field_id: str
        :param project_id: The ID of a project that returned users and groups must have permission to view. To include multiple projects, provide an ampersand-separated list. For example, `projectId=10000&projectId=10001`. This parameter is only used when `fieldId` is present.
        :type project_id: List[str]
        :param issue_type_id: The ID of an issue type that returned users and groups must have permission to view. To include multiple issue types, provide an ampersand-separated list. For example, `issueTypeId=10000&issueTypeId=10001`. Special values, such as `-1` (all standard issue types) and `-2` (all subtask issue types), are supported. This parameter is only used when `fieldId` is present.
        :type issue_type_id: List[str]
        :param avatar_size: The size of the avatar to return. If an invalid value is provided, the default value is used.
        :type avatar_size: str
        :param case_insensitive: Whether the search for groups should be case insensitive.
        :type case_insensitive: bool
        :param exclude_connect_addons: Whether Connect app users and groups should be excluded from the search results. If an invalid value is provided, the default value is used.
        :type exclude_connect_addons: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._find_users_and_groups_serialize(
            query=query,
            max_results=max_results,
            show_avatar=show_avatar,
            field_id=field_id,
            project_id=project_id,
            issue_type_id=issue_type_id,
            avatar_size=avatar_size,
            case_insensitive=case_insensitive,
            exclude_connect_addons=exclude_connect_addons,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FoundUsersAndGroups",
            '400': None,
            '401': None,
            '403': None,
            '429': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _find_users_and_groups_serialize(
        self,
        query,
        max_results,
        show_avatar,
        field_id,
        project_id,
        issue_type_id,
        avatar_size,
        case_insensitive,
        exclude_connect_addons,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'projectId': 'multi',
            'issueTypeId': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if max_results is not None:
            
            _query_params.append(('maxResults', max_results))
            
        if show_avatar is not None:
            
            _query_params.append(('showAvatar', show_avatar))
            
        if field_id is not None:
            
            _query_params.append(('fieldId', field_id))
            
        if project_id is not None:
            
            _query_params.append(('projectId', project_id))
            
        if issue_type_id is not None:
            
            _query_params.append(('issueTypeId', issue_type_id))
            
        if avatar_size is not None:
            
            _query_params.append(('avatarSize', avatar_size))
            
        if case_insensitive is not None:
            
            _query_params.append(('caseInsensitive', case_insensitive))
            
        if exclude_connect_addons is not None:
            
            _query_params.append(('excludeConnectAddons', exclude_connect_addons))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2', 
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/rest/api/3/groupuserpicker',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


